% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flist.R
\name{as.data.frame.fmt_lst}
\alias{as.data.frame.fmt_lst}
\title{Convert a formatting list to a data frame}
\usage{
\method{as.data.frame}{fmt_lst}(x, row.names = NULL, optional = FALSE, ...)
}
\arguments{
\item{x}{The formatting list to convert.}

\item{row.names}{Row names for the returned data frame.  Default is NULL.}

\item{optional}{TRUE or FALSE value indicating whether converting to
syntactic variable names is desired.  In the case of formats, the 
resulting data frame will always be returned with syntactic names, and 
this parameter is ignored.}

\item{...}{Any follow-on parameters.}
}
\value{
A data frame that contains the values stored in the formatting 
list.
}
\description{
This function takes the information stored in a formatting 
list, and converts it to a data frame.  The data frame format is 
useful for storage, editing, saving to a spreadsheet, etc.  The 
data frame shows the name of the formats, their type, and the format 
expression.  For user-defined formats, the data frame populates 
additional columns for the label and order.
}
\examples{
# Create a formatting list
c1 <- flist(num_fmt  = "\%.1f",
            label_fmt = value(condition(x == "A", "Label A"),
                              condition(x == "B", "Label B"),
                              condition(TRUE, "Other")),
            date_fmt = "\%d\%b\%Y")
           
# Convert catalog to data frame to view the structure
df <- as.data.frame(c1)
print(df)
#       Name Type Expression   Label Order
# 1   num_fmt    S       \%.1f            NA
# 2 label_fmt    U   x == "A" Label A    NA
# 3 label_fmt    U   x == "B" Label B    NA
# 4 label_fmt    U       TRUE   Other    NA
# 5  date_fmt    S     \%d\%b\%Y            NA

# Convert data frame back to a formatting list
c2 <- as.flist(df)
c2
# # A formatting list: 3 formats
# - type: column
# - simplify: TRUE
#        Name Type Expression   Label Order
# 1  date_fmt    S     \%d\%b\%Y          <NA>
# 2 label_fmt    U   x == "A" Label A  <NA>
# 3 label_fmt    U   x == "B" Label B  <NA>
# 4 label_fmt    U       TRUE   Other  <NA>
# 5   num_fmt    S       \%.1f          <NA>
}
\seealso{
Other flist: 
\code{\link{as.flist}()},
\code{\link{as.flist.data.frame}()},
\code{\link{as.flist.fcat}()},
\code{\link{as.flist.list}()},
\code{\link{as.flist.tbl_df}()},
\code{\link{flist}()},
\code{\link{is.flist}()},
\code{\link{print.fmt_lst}()},
\code{\link{read.flist}()},
\code{\link{write.flist}()}
}
\concept{flist}
