% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boundaries.R
\name{boundaries}
\alias{boundaries}
\alias{pad}
\alias{put_in_mirror}
\alias{period_bc}
\title{Various boundary conditions for the 2D wavelet transform.}
\usage{
pad(x, N, Ny = N, value = min(x, na.rm = TRUE))

put_in_mirror(x, N, Ny = N)

period_bc(x, N, Ny = N)
}
\arguments{
\item{x}{a real matrix}

\item{N}{the number of rows of the desired output}

\item{Ny}{the number of columns of the desired output, defaults to N}

\item{value}{the value with which the picture is padded by \code{pad}}
}
\value{
a list containing the extended matrix (\code{$res}) and the positions of the original matrix within the extended one (\code{$px} and \code{$py}).
}
\description{
Extend a matrix to the desired size.
}
\details{
\code{pad} pads the fields with a constant value on all sides, be careful what you pick here. \code{put_in_mirror} reflects the input at all edges (with repeated end samples), \code{period_bc} simply repeats the input periodically. In any case, you can retrieve the initial area via \code{bc$res[ bc$px, bc$py ]}.
}
\note{
N and Ny must be at least as big as the input.
}
\examples{
bc <- put_in_mirror( blossom, N=300 )
plot( bc )
print( range( bc$res[ bc$px, bc$py ] - blossom ) )
}
