% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgdstable1.R
\name{pgdstable}
\alias{pgdstable}
\title{The discrete stable distribution: probability generating function}
\usage{
pgdstable(z, alpha, lambda = 1)
}
\arguments{
\item{z}{argument of probability generating function, \code{z} in the interval= \eqn{[-1, 1]}.}

\item{alpha}{tail index parameter \code{alpha} in the interval= \eqn{(0, 1]}.}

\item{lambda}{positive location parameter \code{lambda>0}.}
}
\value{
Returns value of probability generating function of \code{DS(alpha,lambda)}. A warning is displayed for invalid parameter values.
}
\description{
Computes probability generating function of a discrete stable distribution \code{DS(alpha,lambda)}.
}
\examples{
pgdstable(c(-1,0,1),0.5,1)
pgdstable(c(-1,0,1),1,1) #This is Poisson
 curve(pgdstable(x,1,lambda=1), c(-1,1),col=1,ylab='prob. gen. fun.',xlab='z')
 curve(pgdstable(x,0.5,lambda=1), c(-1,1),col=2,add=TRUE)
 curve(pgdstable(x,0.2,lambda=1), c(-1,1),col=4,add=TRUE)
legend('topleft',legend=c(1,0.5,0.1), col=c(1,2,4), lty = 1, title='alpha')
}
\references{
\insertRef{Steutel_1979}{dstabledist}
}
