% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generator.R
\name{yield}
\alias{yield}
\title{Yield a value from a generator}
\usage{
yield(x)
}
\arguments{
\item{x}{A value to yield.}
}
\description{
The \code{yield()} statement suspends \code{\link[=generator]{generator()}} functions. It works
like \code{return()} except that the function continues execution at the
yielding point when it is called again.

\code{yield()} can be called within loops and if-else branches but for
technical reasons it can't be used anywhere in R code:
\itemize{
\item \code{yield()} cannot be called as part of a function argument. Code
such as \code{list(yield())} is illegal.
\item \code{yield()} does not cross function boundaries. You can't use it a
lambda function passed to \code{lapply()} for instance.
}
}
\seealso{
\code{\link[=generator]{generator()}} for examples.
}
