% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_pars.R
\name{rename_pars}
\alias{rename_pars}
\title{Rename parameters in brmsfit objects}
\usage{
rename_pars(x)
}
\arguments{
\item{x}{A \code{brmsfit} object.}
}
\value{
A \code{brmsfit} object with adjusted parameter names.
}
\description{
Rename parameters within the \code{stanfit} object
after model fitting to ensure reasonable parameter names. This function is
usually called automatically by \code{\link{brm}} and users will rarely be
required to call it themselves.
}
\details{
Function \code{rename_pars} is a deprecated alias of \code{rename_pars}.
}
\examples{
\dontrun{
# fit a model manually via rstan
scode <- make_stancode(count ~ Trt, data = epilepsy)
sdata <- make_standata(count ~ Trt, data = epilepsy)
stanfit <- rstan::stan(model_code = scode, data = sdata)

# feed the Stan model back into brms
fit <- brm(count ~ Trt, data = epilepsy, empty = TRUE)
fit$fit <- stanfit
fit <- rename_pars(fit)
summary(fit)
}

}
