% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bliss_Gibbs_Sampler.R
\name{Bliss_Gibbs_Sampler}
\alias{Bliss_Gibbs_Sampler}
\title{Bliss_Gibbs_Sampler}
\usage{
Bliss_Gibbs_Sampler(data, param, verbose = FALSE)
}
\arguments{
\item{data}{a list containing:
\describe{
\item{y}{a numerical vector, the outcome values \code{y_i}.}
\item{x}{a list of matrices, the qth matrix contains the observations of the
      qth functional covariate at time points given by \code{grids}.}
\item{grids}{a list of numerical vectors, the qth vector is the grid of
       time points for the qth functional covariate.}
}}

\item{param}{a list containing:
\describe{
\item{Q}{an integer, the number of functional covariates.}
\item{iter}{an integer, the number of iterations of the Gibbs sampler algorithm.}
\item{K}{a vector of integers, corresponding to the numbers of intervals for
      each covariate.}
\item{p}{an integer, the number of time points.}
\item{basis}{a character (optional). The possible values are "uniform" (default),
      "epanechnikov", "gauss" and "triangular" which correspond to
      different basis functions to expand the coefficient function and the
      functional covariates}
\item{phi_l}{a numerical (optional). An hyperparameters related to the exponential prior
on the length of the intervals. Lower values promotes wider intervals.}
\item{verbose_cpp}{a boolean value (optional). Write stuff from the Rcpp scripts
      if TRUE.}
}}

\item{verbose}{write stuff if TRUE (optional).}
}
\value{
a list containing :
\describe{
 \item{trace}{a matrix, the trace of the Gibbs Sampler.}
 \item{param}{a list containing parameters used to run the function.}
}
}
\description{
A Gibbs Sampler algorithm to sample the posterior distribution of
             the Bliss model.
}
\examples{
\donttest{
param_sim <- list(Q=1,n=25,p=50,grids_lim=list(c(0,1)),iter=2e2,K=2)
data_sim <- sim(param_sim,verbose=FALSE)
res_Bliss_Gibbs_Sampler <- Bliss_Gibbs_Sampler(data_sim,param_sim)
theta_1 <- res_Bliss_Gibbs_Sampler$trace[1,]
theta_1
}
}
