% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptimizerBatchGenSA.R
\name{mlr_optimizers_gensa}
\alias{mlr_optimizers_gensa}
\alias{OptimizerBatchGenSA}
\title{Optimization via Generalized Simulated Annealing}
\source{
Tsallis C, Stariolo DA (1996).
\dQuote{Generalized simulated annealing.}
\emph{Physica A: Statistical Mechanics and its Applications}, \bold{233}(1-2), 395--406.
\doi{10.1016/s0378-4371(96)00271-3}.

Xiang Y, Gubian S, Suomela B, Hoeng J (2013).
\dQuote{Generalized Simulated Annealing for Global Optimization: The GenSA Package.}
\emph{The R Journal}, \bold{5}(1), 13.
\doi{10.32614/rj-2013-002}.
}
\description{
\code{OptimizerBatchGenSA} class that implements generalized simulated annealing. Calls
\code{\link[GenSA:GenSA]{GenSA::GenSA()}} from package \CRANpkg{GenSA}.
}
\section{Dictionary}{

This \link{Optimizer} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link{mlr_optimizers} or with the associated sugar function \code{\link[=opt]{opt()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_optimizers$get("gensa")
opt("gensa")
}\if{html}{\out{</div>}}
}

\section{Parameters}{

\describe{
\item{\code{smooth}}{\code{logical(1)}}
\item{\code{temperature}}{\code{numeric(1)}}
\item{\code{acceptance.param}}{\code{numeric(1)}}
\item{\code{verbose}}{\code{logical(1)}}
\item{\code{trace.mat}}{\code{logical(1)}}
}

For the meaning of the control parameters, see \code{\link[GenSA:GenSA]{GenSA::GenSA()}}. Note that we
have removed all control parameters which refer to the termination of the
algorithm and where our terminators allow to obtain the same behavior.

In contrast to the \code{\link[GenSA:GenSA]{GenSA::GenSA()}} defaults, we set \code{trace.mat = FALSE}.
Note that \code{\link[GenSA:GenSA]{GenSA::GenSA()}} uses \code{smooth = TRUE} as a default.
In the case of using this optimizer for Hyperparameter Optimization you may
want to set \code{smooth = FALSE}.
}

\section{Progress Bars}{

\verb{$optimize()} supports progress bars via the package \CRANpkg{progressr}
combined with a \link{Terminator}. Simply wrap the function in
\code{progressr::with_progress()} to enable them. We recommend to use package
\CRANpkg{progress} as backend; enable with \code{progressr::handlers("progress")}.
}

\examples{
if (requireNamespace("GenSA")) {

  search_space = domain = ps(x = p_dbl(lower = -1, upper = 1))

  codomain = ps(y = p_dbl(tags = "minimize"))

  objective_function = function(xs) {
    list(y = as.numeric(xs)^2)
  }

  objective = ObjectiveRFun$new(
    fun = objective_function,
    domain = domain,
    codomain = codomain)

  instance = OptimInstanceBatchSingleCrit$new(
    objective = objective,
    search_space = search_space,
    terminator = trm("evals", n_evals = 10))

  optimizer = opt("gensa")

  # Modifies the instance by reference
  optimizer$optimize(instance)

  # Returns best scoring evaluation
  instance$result

  # Allows access of data.table of full path of all evaluations
  as.data.table(instance$archive$data)
}
}
\section{Super classes}{
\code{\link[bbotk:Optimizer]{bbotk::Optimizer}} -> \code{\link[bbotk:OptimizerBatch]{bbotk::OptimizerBatch}} -> \code{OptimizerBatchGenSA}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OptimizerBatchGenSA-new}{\code{OptimizerBatchGenSA$new()}}
\item \href{#method-OptimizerBatchGenSA-clone}{\code{OptimizerBatchGenSA$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="format"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-format'><code>bbotk::Optimizer$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="help"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-help'><code>bbotk::Optimizer$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="print"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-print'><code>bbotk::Optimizer$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="OptimizerBatch" data-id="optimize"><a href='../../bbotk/html/OptimizerBatch.html#method-OptimizerBatch-optimize'><code>bbotk::OptimizerBatch$optimize()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimizerBatchGenSA-new"></a>}}
\if{latex}{\out{\hypertarget{method-OptimizerBatchGenSA-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerBatchGenSA$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimizerBatchGenSA-clone"></a>}}
\if{latex}{\out{\hypertarget{method-OptimizerBatchGenSA-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerBatchGenSA$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
