% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ashutility.R
\name{plot_diagnostic}
\alias{plot_diagnostic}
\title{Diagnostic plots for ash object}
\usage{
plot_diagnostic(
  x,
  plot.it = TRUE,
  sebetahat.tol = 0.001,
  plot.hist,
  xmin,
  xmax,
  breaks = "Sturges",
  alpha = 0.01,
  pch = 19,
  cex = 0.25
)
}
\arguments{
\item{x}{the fitted ash object}

\item{plot.it}{logical. whether to plot the diagnostic result}

\item{sebetahat.tol}{tolerance to test the equality of betahat}

\item{plot.hist}{logical. whether to plot the histogram of betahat when sebetahat is not constant}

\item{xmin, xmax}{range of the histogram of betahat to be plotted}

\item{breaks}{histograms parameter (see \code{\link[graphics]{hist}})}

\item{alpha}{error level for the de-trended diagnostic plot}

\item{pch, cex}{plot parameters for dots}
}
\description{
Generate several plots to diagnose the fitness of ASH on the data
}
\details{
None.
}
