% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict}
\alias{predict}
\alias{predict,itemMatrix-method}
\title{Model Predictions}
\usage{
predict(object, ...)

\S4method{predict}{itemMatrix}(object, newdata, labels = NULL, blocksize = 200, ...)
}
\arguments{
\item{object}{clustered examples as an \link{itemMatrix} with cluster label specified in \code{labels} or medoids as an \link{itemMatrix} (use \code{labels = NULL}).}

\item{...}{further arguments passed on to \code{\link[=dissimilarity]{dissimilarity()}}. E.g.,
\code{method}.}

\item{newdata}{an \link{itemMatrix} containing the objects to predict labels for.}

\item{labels}{an integer vector containing the labels for the examples in
\code{object}. The cluster labels need to be contiguous integers starting with 1.}

\item{blocksize}{a numeric scalar indicating how much memory predict can use
for big \code{x} and/or \code{y} (approx. in MB). 200 is only a crude
approximation for 32-bit machines (64-bit architectures need double the
blocksize in memory) and using the default Jaccard method for dissimilarity
calculation.  In general, reducing \code{blocksize} will decrease the memory
usage but will increase the run-time.}
}
\value{
An integer vector of the same length as \code{newdata} containing
the predicted labels for each element.
}
\description{
Provides the method \code{predict()} for \link{itemMatrix} (e.g.,
transactions).  Predicts the membership (nearest neighbor) of new data to
clusters represented by medoids or labeled examples.
}
\examples{
data("Adult")

## sample
small <- sample(Adult, 500)
large <- sample(Adult, 5000)

## cluster a small sample and extract the cluster lael vector
d_jaccard <- dissimilarity(small)
hc <- hclust(d_jaccard)
l <-  cutree(hc, k=4)

## predict labels for a larger sample
labels <- predict(small, large, l)

## plot the profile of the 1. cluster
itemFrequencyPlot(large[labels == 1, itemFrequency(large) > 0.1])
}
\seealso{
Other proximity classes and functions: 
\code{\link{affinity}()},
\code{\link{dissimilarity}()},
\code{\link{proximity-classes}}
}
\author{
Michael Hahsler
}
\concept{proximity classes and functions}
\keyword{cluster}
\keyword{models}
