% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.superset.R
\name{is.superset}
\alias{is.superset}
\alias{is.subset}
\alias{is.superset,itemMatrix-method}
\alias{is.superset,associations-method}
\alias{is.subset,itemMatrix-method}
\alias{is.subset,associations-method}
\title{Find Super and Subsets}
\usage{
is.superset(x, y = NULL, proper = FALSE, sparse = TRUE, ...)

is.subset(x, y = NULL, proper = FALSE, sparse = TRUE, ...)

\S4method{is.superset}{itemMatrix}(x, y = NULL, proper = FALSE, sparse = TRUE)

\S4method{is.superset}{associations}(x, y = NULL, proper = FALSE, sparse = TRUE)

\S4method{is.subset}{itemMatrix}(x, y = NULL, proper = FALSE, sparse = TRUE)

\S4method{is.subset}{associations}(x, y = NULL, proper = FALSE, sparse = TRUE)
}
\arguments{
\item{x, y}{associations or itemMatrix objects. If \code{y = NULL}, the super
or subset structure within set \code{x} is calculated.}

\item{proper}{a logical indicating if all or just proper super or subsets.}

\item{sparse}{a logical indicating if a sparse \link[Matrix:nsparseMatrix-classes]{Matrix::ngCMatrix}
rather than a dense logical matrix should be returned.
Sparse computation requires a
significantly smaller amount of memory and is much faster for large sets.}

\item{...}{currently unused.}
}
\value{
returns a logical matrix or a sparse \link[Matrix:nsparseMatrix-classes]{Matrix::ngCMatrix}
with \code{length(x)} rows and \code{length(y)} columns.
Each logical row vector represents which elements in \code{y} are supersets
(subsets) of the corresponding element in \code{x}.  If either \code{x} or
\code{y} have length zero, \code{NULL} is returned instead of a matrix.
}
\description{
Provides the generic functions \code{is.subset()} and \code{is.superset()}, and the methods
for finding super or subsets in \link{associations} and
\link{itemMatrix} objects.
}
\details{
Determines for each element in \code{x} which elements in \code{y} are supersets
or subsets. Note that the method can be very slow and memory intensive if
\code{x} and/or \code{y} are very dense (contain many items).

For rules, the union of lhs and rhs is used a the set of items.
}
\examples{
data("Adult")
set <- eclat(Adult, parameter = list(supp = 0.8))

### find the supersets of each itemset in set
is.superset(set, set)
is.superset(set, set, sparse = FALSE)
}
\seealso{
Other postprocessing: 
\code{\link{is.closed}()},
\code{\link{is.generator}()},
\code{\link{is.maximal}()},
\code{\link{is.redundant}()},
\code{\link{is.significant}()}

Other associations functions: 
\code{\link{abbreviate}()},
\code{\link{associations-class}},
\code{\link{c}()},
\code{\link{duplicated}()},
\code{\link{extract}},
\code{\link{inspect}()},
\code{\link{is.closed}()},
\code{\link{is.generator}()},
\code{\link{is.maximal}()},
\code{\link{is.redundant}()},
\code{\link{is.significant}()},
\code{\link{itemsets-class}},
\code{\link{match}()},
\code{\link{rules-class}},
\code{\link{sample}()},
\code{\link{sets}},
\code{\link{size}()},
\code{\link{sort}()},
\code{\link{unique}()}

Other itemMatrix and transactions functions: 
\code{\link{abbreviate}()},
\code{\link{c}()},
\code{\link{crossTable}()},
\code{\link{duplicated}()},
\code{\link{extract}},
\code{\link{hierarchy}},
\code{\link{image}()},
\code{\link{inspect}()},
\code{\link{itemFrequency}()},
\code{\link{itemFrequencyPlot}()},
\code{\link{itemMatrix-class}},
\code{\link{match}()},
\code{\link{merge}()},
\code{\link{random.transactions}()},
\code{\link{sample}()},
\code{\link{sets}},
\code{\link{size}()},
\code{\link{supportingTransactions}()},
\code{\link{tidLists-class}},
\code{\link{transactions-class}},
\code{\link{unique}()}
}
\author{
Michael Hahsler and Ian Johnson
}
\concept{associations functions}
\concept{itemMatrix and transactions functions}
\concept{postprocessing}
\keyword{manip}
