% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SQLColumnSeed.R
\name{SQLColumnSeed}
\alias{SQLColumnSeed}
\alias{SQLColumnSeed-class}
\alias{dim,SQLColumnSeed-method}
\alias{type,SQLColumnSeed-method}
\alias{path,SQLColumnSeed-method}
\alias{sqltable,SQLColumnSeed-method}
\alias{extract_array,SQLColumnSeed-method}
\alias{SQLColumnVector-class}
\alias{DelayedArray,SQLColumnSeed-method}
\alias{SQLColumnVector}
\title{Column of a SQL table}
\usage{
SQLColumnSeed(path, dbtype, table, column, length = NULL, type = NULL)

SQLColumnVector(x, ...)
}
\arguments{
\item{path}{String containing a path to a SQL file.}

\item{dbtype}{String containing the SQL database type (case
insensitive). Supported types are "SQLite" and "DuckDB".}

\item{table}{String containing the name of the table in SQL file.}

\item{column}{String containing the name of the column inside the
table.}

\item{length}{Integer containing the number of rows. If
\code{NULL}, this is determined by inspecting the SQL
table. This should only be supplied for efficiency purposes, to
avoid a file look-up on construction.}

\item{type}{String specifying the type of the data. If \code{NULL},
this is determined by inspecting the file. Users may specify
this to avoid a look-up, or to coerce the output into a
different type.}

\item{x}{A SQLColumnSeed object.}

\item{...}{Further arguments to be passed to the
    \code{SQLColumnSeed} constructor.
#'}
}
\value{
For \code{SQLColumnSeed}: a SQLColumnSeed. For
    \code{SQLColumnVector}: a SQLColumnVector.
#'
}
\description{
Represent a column of a SQL table as a 1-dimensional
\linkS4class{DelayedArray}.  This allows us to use SQL data inside
\linkS4class{DataFrame}s without loading them into memory.
}
\examples{
# Mocking up a file:
tf <- tempfile()
on.exit(unlink(tf))
con <- DBI::dbConnect(RSQLite::SQLite(), tf)
DBI::dbWriteTable(con, "mtcars", mtcars)
DBI::dbDisconnect(con)

# Creating a vector:
SQLColumnVector(tf, dbtype = "SQLite", "mtcars", column="gear")

# This happily lives inside DataFrames:
collected <- list()
for (x in colnames(mtcars)) {
    collected[[x]] <- SQLColumnVector(tf, dbtype = "SQLite", "mtcars", column=x)
}
DataFrame(collected)
#'
}
\author{
Qian Liu
}
