## ----echo=FALSE---------------------------------------------------------------
library(BiocStyle)
self <- Biocpkg("SQLDataFrame");
knitr::opts_chunk$set(error=FALSE, warning=FALSE, message=FALSE)

## ----getPackage, eval=FALSE---------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("SQLDataFrame")

## ----Load, message=FALSE------------------------------------------------------
library(SQLDataFrame)

## -----------------------------------------------------------------------------
## Mocking up a file.
tf <- tempfile()
con <- DBI::dbConnect(RSQLite::SQLite(), tf)
DBI::dbWriteTable(con, "mtcars", mtcars)
DBI::dbDisconnect(con)


## Creating the SQLiteDataFrame.
library(SQLDataFrame)
df <- SQLDataFrame(tf, dbtype = "sqlite", table = "mtcars")
df0 <- SQLiteDataFrame(tf, table = "mtcars")
identical(df, df0)

## -----------------------------------------------------------------------------
tf1 <- tempfile()
on.exit(unlist(tf1))
con <- DBI::dbConnect(duckdb::duckdb(), tf1)
DBI::dbWriteTable(con, "mtcars", mtcars)
DBI::dbDisconnect(con)

df1 <- SQLDataFrame(tf1, dbtype = "duckdb", table = "mtcars")
df2 <- DuckDBDataFrame(tf1, table = "mtcars")
identical(df1, df2)

## -----------------------------------------------------------------------------
nrow(df)
colnames(df)
class(as.data.frame(df))

## -----------------------------------------------------------------------------
df$mpg

# These can participate in usual vector operations:
df$mpg * 10
log1p(df$mpg)

# Realize this into an ordinary vector.
as.vector(df$mpg)

## -----------------------------------------------------------------------------
copy <- df
copy$some_random_thing <- runif(nrow(df))
class(copy)
colnames(copy)

## -----------------------------------------------------------------------------
copy$wt <- copy$wt * 1000
top.hits <- head(copy)
top.hits

## -----------------------------------------------------------------------------
handle <- acquireConn(path(df), dbtype = dbtype(df))
handle
releaseConn(path(df))

## -----------------------------------------------------------------------------
sessionInfo()

