% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Counter.R
\name{newStateLogger}
\alias{newStateLogger}
\title{Create a logger of the StateLogger class}
\arguments{
\item{name}{the name of the logger. A length-1 character vector}

\item{agent}{the agent whose state will be logged. An external pointer}

\item{state.name}{the state name of the state of the agent to be logged.
A character vector of length 1.}
}
\description{
When state changes occur, it is passed to each logger, which then
change its value. At the specified time points in a run, the
values of the logger are reported and recorded in a data.frame object,
where the columns represent variables, and rows represent the
observation at each time point given to each run. Each logger has a
name, which becomes the the column name in the data.frame.
}
\details{
If a state changed happened to any agent, the specified state
of the agent given by the "agent" argument will be logged. If
\code{state.name==NULL} then the state of the agent who just changed is
logged.

The agent must be an external pointer. To use an R6 object, we need
to use its $get method to get the external pointer.

The state to be logged must have a numeric value.
}
