/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.ExternalTMX;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.RealProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.util.StringUtil;
import org.omegat.util.TMXProp;

public class ImportFromAutoTMX {
    final RealProject project;
    Map<String, List<SourceTextEntry>> existEntries = new HashMap<String, List<SourceTextEntry>>();

    public ImportFromAutoTMX(RealProject project, List<SourceTextEntry> allProjectEntries) {
        this.project = project;
        for (SourceTextEntry ste : allProjectEntries) {
            List<SourceTextEntry> list = this.existEntries.get(ste.getSrcText());
            if (list == null) {
                list = new ArrayList<SourceTextEntry>();
                this.existEntries.put(ste.getSrcText(), list);
            }
            list.add(ste);
        }
    }

    void process(ExternalTMX tmx, boolean isEnforcedTMX) {
        for (PrepareTMXEntry e : tmx.getEntries()) {
            List<SourceTextEntry> list = this.existEntries.get(e.source);
            if (list == null) continue;
            for (SourceTextEntry ste : list) {
                boolean has100PC;
                TMXEntry existTranslation = this.project.getTranslationInfo(ste);
                String id = ste.getKey().id;
                boolean hasICE = id != null && e.hasPropValue("x-ice", id);
                boolean bl = has100PC = id != null && e.hasPropValue("x-100pc", id);
                if (e.hasPropValue("foreignMatch", "true")) continue;
                if (!hasICE && !has100PC) {
                    boolean isDefaultTranslation;
                    boolean bl2 = isDefaultTranslation = !this.isAltTranslation(e);
                    if (!existTranslation.defaultTranslation && isDefaultTranslation || !isDefaultTranslation && !this.altTranslationMatches(e, ste.getKey())) continue;
                    if (isEnforcedTMX && (!existTranslation.isTranslated() || existTranslation.linked != TMXEntry.ExternalLinked.xENFORCED)) {
                        this.setTranslation(ste, e, isDefaultTranslation, TMXEntry.ExternalLinked.xENFORCED);
                        continue;
                    }
                    if (existTranslation.isTranslated()) continue;
                    this.setTranslation(ste, e, isDefaultTranslation, TMXEntry.ExternalLinked.xAUTO);
                    continue;
                }
                if (!existTranslation.isTranslated() || existTranslation.defaultTranslation) {
                    if (hasICE) {
                        this.setTranslation(ste, e, false, TMXEntry.ExternalLinked.xICE);
                        continue;
                    }
                    if (!has100PC) continue;
                    this.setTranslation(ste, e, false, TMXEntry.ExternalLinked.x100PC);
                    continue;
                }
                if (existTranslation.linked == TMXEntry.ExternalLinked.xICE || existTranslation.linked == TMXEntry.ExternalLinked.x100PC) {
                    if (!hasICE || Objects.equals(existTranslation.translation, e.translation)) continue;
                    this.setTranslation(ste, e, false, TMXEntry.ExternalLinked.xICE);
                    continue;
                }
                if (existTranslation.linked != TMXEntry.ExternalLinked.x100PC || !has100PC || Objects.equals(existTranslation.translation, e.translation)) continue;
                this.setTranslation(ste, e, false, TMXEntry.ExternalLinked.x100PC);
            }
        }
    }

    private boolean isAltTranslation(PrepareTMXEntry entry) {
        if (entry.otherProperties == null) {
            return false;
        }
        boolean hasFileProp = false;
        boolean hasOtherProp = false;
        for (TMXProp p : entry.otherProperties) {
            if (p.getType().equals("file")) {
                hasFileProp = true;
                continue;
            }
            if (!p.getType().equals("id") && !p.getType().equals("tuid") && !p.getType().equals("next") && !p.getType().equals("path") && !p.getType().equals("prev")) continue;
            hasOtherProp = true;
        }
        return EntryKey.isIgnoreFileContext() ? hasOtherProp : hasFileProp;
    }

    private boolean altTranslationMatches(PrepareTMXEntry entry, EntryKey key) {
        if (entry.otherProperties == null) {
            return false;
        }
        String file = null;
        String id = null;
        String next = null;
        String prev = null;
        String path = null;
        for (TMXProp p : entry.otherProperties) {
            if ("file".equals(p.getType())) {
                file = p.getValue();
                continue;
            }
            if ("id".equals(p.getType())) {
                id = p.getValue();
                continue;
            }
            if ("tuid".equals(p.getType()) && id == null) {
                id = p.getValue();
                continue;
            }
            if ("next".equals(p.getType())) {
                next = p.getValue();
                continue;
            }
            if ("prev".equals(p.getType())) {
                prev = p.getValue();
                continue;
            }
            if (!"path".equals(p.getType())) continue;
            path = p.getValue();
        }
        return key.equals(new EntryKey(file, entry.source, id, prev, next, path));
    }

    private void setTranslation(SourceTextEntry entry, PrepareTMXEntry trans, boolean defaultTranslation, TMXEntry.ExternalLinked externalLinked) {
        if (StringUtil.isEmpty(trans.note)) {
            trans.note = null;
        }
        trans.source = entry.getSrcText();
        TMXEntry newTrEntry = trans.translation == null && trans.note == null ? null : new TMXEntry(trans, defaultTranslation, externalLinked);
        this.project.projectTMX.setTranslation(entry, newTrEntry, defaultTranslation);
    }
}

