/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.util.ArrayList;
import java.util.List;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;

public final class RecentProjects {
    private static final List<String> RECENT_PROJECTS;
    private static final int MOST_RECENT_PROJECT_SIZE;

    private RecentProjects() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveToPrefs() {
        List<String> list = RECENT_PROJECTS;
        synchronized (list) {
            for (int i = 0; i < MOST_RECENT_PROJECT_SIZE; ++i) {
                String project = i < RECENT_PROJECTS.size() ? RECENT_PROJECTS.get(i) : "";
                Preferences.setPreference("most_recent_projects_" + i, project);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getRecentProjects() {
        List<String> list = RECENT_PROJECTS;
        synchronized (list) {
            return new ArrayList<String>(RECENT_PROJECTS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(String element) {
        if (StringUtil.isEmpty(element)) {
            return;
        }
        List<String> list = RECENT_PROJECTS;
        synchronized (list) {
            RECENT_PROJECTS.remove(element);
            RECENT_PROJECTS.add(0, element);
            while (RECENT_PROJECTS.size() > MOST_RECENT_PROJECT_SIZE) {
                RECENT_PROJECTS.remove(MOST_RECENT_PROJECT_SIZE);
            }
        }
        RecentProjects.saveToPrefs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        List<String> list = RECENT_PROJECTS;
        synchronized (list) {
            RECENT_PROJECTS.clear();
        }
        RecentProjects.saveToPrefs();
    }

    static {
        MOST_RECENT_PROJECT_SIZE = Preferences.getPreferenceDefault("most_recent_projects_size", 10);
        RECENT_PROJECTS = new ArrayList<String>(MOST_RECENT_PROJECT_SIZE);
        for (int i = 0; i < MOST_RECENT_PROJECT_SIZE; ++i) {
            String project = Preferences.getPreferenceDefault("most_recent_projects_" + i, null);
            if (project == null) continue;
            RECENT_PROJECTS.add(project);
        }
    }
}

