/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.languagetool.rules.ConfusionSet;
import org.languagetool.rules.ConfusionString;

public class ConfusionSetLoader {
    private static final String CHARSET = "utf-8";

    public Map<String, List<ConfusionSet>> loadConfusionSet(InputStream stream) throws IOException {
        HashMap<String, List<ConfusionSet>> map = new HashMap<String, List<ConfusionSet>>();
        try (InputStreamReader reader = new InputStreamReader(stream, CHARSET);
             BufferedReader br = new BufferedReader(reader);){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#") || line.trim().isEmpty()) continue;
                String[] parts = line.replaceFirst("\\s*#.*", "").split(";\\s*");
                if (parts.length != 3) {
                    throw new RuntimeException("Unexpected format: '" + line + "' - expected three semicolon-separated values: word1; word2; factor");
                }
                ArrayList<ConfusionString> confusionStrings = new ArrayList<ConfusionString>();
                HashSet<String> loadedForSet = new HashSet<String>();
                for (String part : Arrays.asList(parts).subList(0, parts.length - 1)) {
                    String description;
                    String[] subParts = part.split("\\|");
                    String word = subParts[0];
                    String string = description = subParts.length == 2 ? subParts[1] : null;
                    if (loadedForSet.contains(word)) {
                        throw new RuntimeException("Word appears twice in same confusion set: '" + word + "'");
                    }
                    confusionStrings.add(new ConfusionString(word, description));
                    loadedForSet.add(word);
                }
                ConfusionSet confusionSet = new ConfusionSet(Long.parseLong(parts[parts.length - 1]), confusionStrings);
                for (ConfusionString confusionString : confusionStrings) {
                    String key = confusionString.getString();
                    List existingEntry = (List)map.get(key);
                    if (existingEntry != null) {
                        existingEntry.add(confusionSet);
                        continue;
                    }
                    ArrayList<ConfusionSet> sets = new ArrayList<ConfusionSet>();
                    sets.add(confusionSet);
                    map.put(key, sets);
                }
            }
        }
        return map;
    }
}

