/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.preferences.view;

import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.omegat.gui.dialogs.VersionCheckDialog;
import org.omegat.gui.preferences.BasePreferencesController;
import org.omegat.gui.preferences.view.VersionCheckPreferencesPanel;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;

public class VersionCheckPreferencesController
extends BasePreferencesController {
    private VersionCheckPreferencesPanel panel;

    @Override
    public JComponent getGui() {
        if (this.panel == null) {
            this.initGui();
            this.initFromPrefs();
        }
        return this.panel;
    }

    @Override
    public String toString() {
        return OStrings.getString("PREFS_TITLE_VERSION_CHECK");
    }

    private void initGui() {
        this.panel = new VersionCheckPreferencesPanel();
        this.panel.checkNowButton.addActionListener(e -> VersionCheckDialog.checkAndShowResultAsync(SwingUtilities.getWindowAncestor(this.panel)));
        this.panel.currentVersionLabel.setText(OStrings.getString("PREFS_VERSION_CURRENT_VERSION", OStrings.getSimpleVersion()));
        this.panel.updateChannelLabel.setText(OStrings.getString("PREFS_VERSION_UPDATE_CHANNEL", OStrings.IS_BETA ? OStrings.getString("PREFS_VERSION_CHANNEL_LATEST") : OStrings.getString("PREFS_VERSION_CHANNEL_STABLE")));
    }

    @Override
    protected void initFromPrefs() {
        this.panel.autoCheckCheckBox.setSelected(Preferences.isPreferenceDefault("automatically_check_version", true));
    }

    @Override
    public void restoreDefaults() {
        this.panel.autoCheckCheckBox.setSelected(true);
    }

    @Override
    public void persist() {
        Preferences.setPreference("automatically_check_version", this.panel.autoCheckCheckBox.isSelected());
    }
}

