/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.preferences.view;

import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.omegat.core.matching.NearString;
import org.omegat.gui.matches.MatchesVarExpansion;
import org.omegat.gui.preferences.BasePreferencesController;
import org.omegat.gui.preferences.view.TMMatchesPreferencesPanel;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.gui.DelegatingComboBoxRenderer;

public class TMMatchesPreferencesController
extends BasePreferencesController {
    private TMMatchesPreferencesPanel panel;

    @Override
    public JComponent getGui() {
        if (this.panel == null) {
            this.initGui();
            this.initFromPrefs();
        }
        return this.panel;
    }

    @Override
    public String toString() {
        return OStrings.getString("PREFS_TITLE_TM_MATCHES");
    }

    private void initGui() {
        this.panel = new TMMatchesPreferencesPanel();
        this.panel.sortMatchesList.setModel(new DefaultComboBoxModel<NearString.SORT_KEY>(NearString.SORT_KEY.values()));
        this.panel.sortMatchesList.setRenderer((ListCellRenderer<NearString.SORT_KEY>)new DelegatingComboBoxRenderer<NearString.SORT_KEY, String>(){

            @Override
            protected String getDisplayText(NearString.SORT_KEY value) {
                return OStrings.getString("EXT_TMX_SORT_KEY_" + value.name());
            }
        });
        this.panel.sortMatchesList.addActionListener(e -> {
            boolean changed = this.valueIsDifferent("ext_tmx_sort_key", this.panel.sortMatchesList.getSelectedItem());
            this.setReloadRequired(changed);
        });
        this.panel.insertButton.addActionListener(e -> this.panel.matchesTemplate.replaceSelection(this.panel.variablesList.getSelectedItem().toString()));
        this.panel.variablesList.setModel(new DefaultComboBoxModel<String>(new Vector<String>(MatchesVarExpansion.getMatchesVariables())));
    }

    @Override
    protected void initFromPrefs() {
        this.panel.sortMatchesList.getModel().setSelectedItem((Object)Preferences.getPreferenceEnumDefault("ext_tmx_sort_key", NearString.SORT_KEY.SCORE));
        this.panel.displayLevel2Tags.setSelected(Preferences.isPreference("ext_tmx_show_level2"));
        this.panel.useSlash.setSelected(Preferences.isPreference("ext_tmx_use_slash"));
        this.panel.matchesTemplate.setText(Preferences.getPreferenceDefault("ext_tmx_match_template", "${id}. ${fuzzyFlag}${sourceText}\n${targetText}\n<${score}/${noStemScore}/${adjustedScore}% ${filePath}>"));
        this.panel.matchesTemplate.setCaretPosition(0);
    }

    @Override
    public void restoreDefaults() {
        this.panel.sortMatchesList.getModel().setSelectedItem((Object)NearString.SORT_KEY.SCORE);
        this.panel.displayLevel2Tags.setSelected(false);
        this.panel.useSlash.setSelected(false);
        this.panel.matchesTemplate.setText("${id}. ${fuzzyFlag}${sourceText}\n${targetText}\n<${score}/${noStemScore}/${adjustedScore}% ${filePath}>");
        this.panel.matchesTemplate.setCaretPosition(0);
    }

    @Override
    public void persist() {
        Preferences.setPreference("ext_tmx_sort_key", (Object)((NearString.SORT_KEY)((Object)this.panel.sortMatchesList.getSelectedItem())));
        Preferences.setPreference("ext_tmx_show_level2", this.panel.displayLevel2Tags.isSelected());
        Preferences.setPreference("ext_tmx_use_slash", this.panel.useSlash.isSelected());
        Preferences.setPreference("ext_tmx_match_template", this.panel.matchesTemplate.getText());
    }
}

