/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary.taas;

import gen.taas.TaasArrayOfTerm;
import gen.taas.TaasCollection;
import gen.taas.TaasCollections;
import gen.taas.TaasDomain;
import gen.taas.TaasDomains;
import gen.taas.TaasExtractionResult;
import gen.taas.TaasTerm;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import org.apache.commons.io.IOUtils;
import org.omegat.gui.glossary.taas.TaaSPlugin;
import org.omegat.util.CredentialsManager;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;

public class TaaSClient {
    private static final Logger LOGGER = Logger.getLogger(TaaSClient.class.getName());
    private static final String PROPERTY_API_KEY = "taas.user.key";
    public static final String WS_URL = "https://api.taas-project.eu";
    public static final String M_USERNAME = "OmegaT";
    public static final String M_PASSWORD = "Ts1DW4^UpE";
    private static final String BASIC_AUTH = "Basic " + Base64.getMimeEncoder().encodeToString("OmegaT:Ts1DW4^UpE".getBytes(StandardCharsets.ISO_8859_1));
    public static final String EXTRACTION_METHOD = "4";
    private JAXBContext context;
    private String taasUserKey;

    public void init() throws Exception {
        this.loadApiKey();
        if (this.isAllowed()) {
            this.initContext();
        }
    }

    public String getApiKey() {
        return this.taasUserKey;
    }

    private void loadApiKey() {
        String property = System.getProperty(PROPERTY_API_KEY);
        this.taasUserKey = !StringUtil.isEmpty(property) ? property : CredentialsManager.getInstance().retrieve(PROPERTY_API_KEY).orElse("");
    }

    public void setApiKey(String key, boolean temporary) throws Exception {
        this.taasUserKey = key;
        this.storeApiKey(key, temporary);
        if (this.isAllowed()) {
            this.initContext();
        }
    }

    private void storeApiKey(String key, boolean temporary) {
        System.setProperty(PROPERTY_API_KEY, key);
        CredentialsManager.getInstance().store(PROPERTY_API_KEY, temporary ? "" : key);
    }

    public boolean isApiKeyStoredTemporarily() {
        return !CredentialsManager.getInstance().isStored(PROPERTY_API_KEY) && !System.getProperty(PROPERTY_API_KEY, "").isEmpty();
    }

    private void initContext() throws Exception {
        if (this.context == null) {
            this.context = JAXBContext.newInstance((Class[])new Class[]{TaasCollections.class, TaasArrayOfTerm.class, TaasExtractionResult.class, TaasDomains.class});
        }
    }

    public boolean isAllowed() {
        return !StringUtil.isEmpty(this.taasUserKey);
    }

    HttpURLConnection requestGet(String url) throws IOException, Unauthorized, FormatError {
        Log.logInfoRB("TAAS_REQUEST", url);
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setRequestProperty("Authorization", BASIC_AUTH);
        if (!StringUtil.isEmpty(this.taasUserKey)) {
            conn.setRequestProperty("TaaS-User-Key", this.taasUserKey);
        }
        conn.setRequestProperty("Accept", "text/xml");
        if (conn.getResponseCode() == 401) {
            throw new Unauthorized();
        }
        if (conn.getResponseCode() != 200) {
            throw new FormatError(conn.getResponseCode() + " " + conn.getResponseMessage());
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HttpURLConnection requestPost(String url, String body) throws IOException, Unauthorized, FormatError {
        Log.logInfoRB("TAAS_REQUEST", url);
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setRequestProperty("Authorization", BASIC_AUTH);
        if (this.taasUserKey != null) {
            conn.setRequestProperty("TaaS-User-Key", this.taasUserKey);
        }
        conn.setRequestProperty("Accept", "text/xml");
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "text/plain");
        conn.setDoOutput(true);
        try (OutputStream out = conn.getOutputStream();){
            out.write(body.getBytes(StandardCharsets.UTF_8));
        }
        if (conn.getResponseCode() == 401) {
            throw new Unauthorized();
        }
        if (conn.getResponseCode() != 200) {
            throw new FormatError(conn.getResponseCode() + " " + conn.getResponseMessage());
        }
        return conn;
    }

    void checkXMLContentType(HttpURLConnection conn) throws FormatError {
        String contentType = conn.getHeaderField("Content-Type");
        if (contentType == null) {
            throw new FormatError("Empty Content-Type header");
        }
        String ct = contentType.replace(" ", "").toLowerCase(Locale.ENGLISH);
        if (!"text/xml".equals(ct) && !"application/xml".equals(ct)) {
            throw new FormatError("Wrong Content-Type header: " + contentType);
        }
    }

    void checkXMLUTF8ContentType(HttpURLConnection conn) throws FormatError {
        String contentType = conn.getHeaderField("Content-Type");
        if (contentType == null) {
            throw new FormatError("Empty Content-Type header");
        }
        String ct = contentType.replace(" ", "").toLowerCase(Locale.ENGLISH);
        if (!"text/xml;charset=utf-8".equals(ct) && !"application/xml;charset=utf-8".equals(ct)) {
            throw new FormatError("Wrong Content-Type header: " + contentType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String readUTF8(HttpURLConnection conn) throws IOException {
        try (InputStream in = conn.getInputStream();){
            String string = IOUtils.toString(in, StandardCharsets.UTF_8);
            return string;
        }
    }

    List<TaasCollection> getCollectionsList() throws IOException, Unauthorized, FormatError {
        TaasCollections result;
        HttpURLConnection conn = this.requestGet("https://api.taas-project.eu/collections");
        this.checkXMLUTF8ContentType(conn);
        String data = this.readUTF8(conn);
        try {
            result = (TaasCollections)this.context.createUnmarshaller().unmarshal((Reader)new StringReader(data));
        }
        catch (Exception ex) {
            throw new FormatError("Wrong content: " + ex.getMessage());
        }
        Log.logDebug(LOGGER, "getCollectionsList() returns {0} collections", result.getCollection().size());
        return result.getCollection();
    }

    List<TaasDomain> getDomainsList() throws IOException, Unauthorized, FormatError {
        TaasDomains result;
        HttpURLConnection conn = this.requestGet("https://api.taas-project.eu/domains");
        this.checkXMLUTF8ContentType(conn);
        String data = this.readUTF8(conn);
        try {
            result = (TaasDomains)this.context.createUnmarshaller().unmarshal((Reader)new StringReader(data));
        }
        catch (Exception ex) {
            throw new FormatError("Wrong content: " + ex.getMessage());
        }
        Log.logDebug(LOGGER, "getDomainsList() returns {0} domains", result.getDomain().size());
        return result.getDomain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void downloadCollection(long collectionId, File outFile) throws Exception {
        HttpURLConnection conn = this.requestGet("https://api.taas-project.eu/collections/" + collectionId);
        this.checkXMLContentType(conn);
        try (InputStream in = conn.getInputStream();
             BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFile));){
            TaaSPlugin.filterTaasResult(in, out);
        }
        Log.logDebug(LOGGER, "Collection {0} downloaded", collectionId);
    }

    List<TaasTerm> termLookup(Language sourceLang, Language targetLang, String term) throws IOException, Unauthorized, FormatError {
        TaasArrayOfTerm result;
        HttpURLConnection conn = this.requestGet("https://api.taas-project.eu/lookup/" + sourceLang.getLanguageCode().toLowerCase() + "/" + URLEncoder.encode(term, "UTF-8") + "?targetLang=" + targetLang.getLanguageCode().toLowerCase());
        this.checkXMLUTF8ContentType(conn);
        String data = this.readUTF8(conn);
        try {
            result = (TaasArrayOfTerm)this.context.createUnmarshaller().unmarshal((Reader)new StringReader(data));
        }
        catch (Exception ex) {
            throw new FormatError("Wrong content: " + ex.getMessage());
        }
        Log.logDebug(LOGGER, "termLookup returns {0} results", result.getTerm().size());
        return result.getTerm();
    }

    TaasExtractionResult termExtraction(Language sourceLang, Language targetLang, String text, String domain) throws IOException, Unauthorized, FormatError {
        TaasExtractionResult result;
        StringBuilder r = new StringBuilder();
        r.append(WS_URL).append("/extraction/");
        r.append("?sourceLang=").append(sourceLang.getLanguageCode().toLowerCase(Locale.ENGLISH));
        r.append("&targetLang=").append(targetLang.getLanguageCode().toLowerCase(Locale.ENGLISH));
        r.append("&method=").append(EXTRACTION_METHOD);
        if (!StringUtil.isEmpty(domain)) {
            r.append("&domain=").append(URLEncoder.encode(domain, "UTF-8"));
        }
        HttpURLConnection conn = this.requestPost(r.toString(), text);
        this.checkXMLUTF8ContentType(conn);
        String data = this.readUTF8(conn);
        try {
            result = (TaasExtractionResult)this.context.createUnmarshaller().unmarshal((Reader)new StringReader(data));
        }
        catch (Exception ex) {
            throw new FormatError("Wrong content: " + ex.getMessage());
        }
        Log.logDebug(LOGGER, "termExtraction returns data", new Object[0]);
        return result;
    }

    public static class FormatError
    extends Exception {
        public FormatError(String text) {
            super(text);
        }
    }

    public static class Unauthorized
    extends Exception {
        public Unauthorized() {
            super(OStrings.getString("TAAS_UNAUTHORIZED_ERROR"));
        }
    }
}

