/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.ml.BeamSearch;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ml.model.SequenceClassificationModel;
import opennlp.tools.postag.POSDictionary;
import opennlp.tools.postag.POSTaggerFactory;
import opennlp.tools.postag.TagDictionary;
import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.BaseModel;

public final class POSModel
extends BaseModel {
    private static final String COMPONENT_NAME = "POSTaggerME";
    public static final String POS_MODEL_ENTRY_NAME = "pos.model";

    public POSModel(String languageCode, MaxentModel posModel, POSDictionary tagDictionary, Dictionary ngramDict, Map<String, String> manifestInfoEntries) {
        this(languageCode, posModel, manifestInfoEntries, new POSTaggerFactory(ngramDict, tagDictionary));
    }

    public POSModel(String languageCode, MaxentModel posModel, POSDictionary tagDictionary, Dictionary ngramDict) {
        this(languageCode, posModel, 3, null, new POSTaggerFactory(ngramDict, tagDictionary));
    }

    public POSModel(String languageCode, SequenceClassificationModel<String> posModel, Map<String, String> manifestInfoEntries, POSTaggerFactory posFactory) {
        super(COMPONENT_NAME, languageCode, manifestInfoEntries, posFactory);
        if (posModel == null) {
            throw new IllegalArgumentException("The maxentPosModel param must not be null!");
        }
        this.artifactMap.put(POS_MODEL_ENTRY_NAME, posModel);
    }

    public POSModel(String languageCode, MaxentModel posModel, Map<String, String> manifestInfoEntries, POSTaggerFactory posFactory) {
        this(languageCode, posModel, 3, manifestInfoEntries, posFactory);
    }

    public POSModel(String languageCode, MaxentModel posModel, int beamSize, Map<String, String> manifestInfoEntries, POSTaggerFactory posFactory) {
        super(COMPONENT_NAME, languageCode, manifestInfoEntries, posFactory);
        if (posModel == null) {
            throw new IllegalArgumentException("The maxentPosModel param must not be null!");
        }
        Properties manifest = (Properties)this.artifactMap.get("manifest.properties");
        manifest.setProperty("BeamSize", Integer.toString(beamSize));
        this.artifactMap.put(POS_MODEL_ENTRY_NAME, posModel);
        this.checkArtifactMap();
    }

    public POSModel(InputStream in) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, in);
    }

    public POSModel(File modelFile) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, modelFile);
    }

    public POSModel(URL modelURL) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, modelURL);
    }

    @Override
    protected Class<? extends BaseToolFactory> getDefaultFactory() {
        return POSTaggerFactory.class;
    }

    @Override
    protected void createArtifactSerializers(Map<String, ArtifactSerializer> serializers) {
        super.createArtifactSerializers(serializers);
    }

    @Override
    protected void validateArtifactMap() throws InvalidFormatException {
        super.validateArtifactMap();
        if (!(this.artifactMap.get(POS_MODEL_ENTRY_NAME) instanceof MaxentModel)) {
            throw new InvalidFormatException("POS model is incomplete!");
        }
    }

    @Deprecated
    public MaxentModel getPosModel() {
        if (this.artifactMap.get(POS_MODEL_ENTRY_NAME) instanceof MaxentModel) {
            return (MaxentModel)this.artifactMap.get(POS_MODEL_ENTRY_NAME);
        }
        return null;
    }

    public SequenceClassificationModel<String> getPosSequenceModel() {
        Properties manifest = (Properties)this.artifactMap.get("manifest.properties");
        if (this.artifactMap.get(POS_MODEL_ENTRY_NAME) instanceof MaxentModel) {
            String beamSizeString = manifest.getProperty("BeamSize");
            int beamSize = 3;
            if (beamSizeString != null) {
                beamSize = Integer.parseInt(beamSizeString);
            }
            return new BeamSearch<String>(beamSize, (MaxentModel)this.artifactMap.get(POS_MODEL_ENTRY_NAME));
        }
        if (this.artifactMap.get(POS_MODEL_ENTRY_NAME) instanceof SequenceClassificationModel) {
            return (SequenceClassificationModel)this.artifactMap.get(POS_MODEL_ENTRY_NAME);
        }
        return null;
    }

    public POSDictionary getTagDictionary() {
        TagDictionary dict;
        if (this.getFactory() != null && (dict = this.getFactory().getTagDictionary()) != null) {
            if (dict instanceof POSDictionary) {
                return (POSDictionary)dict;
            }
            String clazz = dict.getClass().getCanonicalName();
            throw new IllegalStateException("Can not get a dictionary of type " + clazz + " using the deprecated method POSModel.getTagDictionary() " + "because it can only return dictionaries of type POSDictionary. " + "Use POSModel.getFactory().getTagDictionary() instead.");
        }
        return null;
    }

    public POSTaggerFactory getFactory() {
        return (POSTaggerFactory)this.toolFactory;
    }

    public Dictionary getNgramDictionary() {
        if (this.getFactory() != null) {
            return this.getFactory().getDictionary();
        }
        return null;
    }
}

