/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.bits;

import edu.berkeley.nlp.lm.array.LongArray;

public final class BitStream {
    private static final long LOG_LONG_SIZE = 64 - Long.numberOfLeadingZeros(63L);
    private static final long LOG_LONG_MASK = (1L << (int)LOG_LONG_SIZE) - 1L;
    private static final long HIGH_BIT_MASK = Long.MIN_VALUE;
    private final LongArray data;
    private final long start;
    private long currLong = -1L;
    private long currPos = -1L;
    private int relBit;
    private long markedCurrPos = -1L;
    private int markedRelBit = -1;
    private final int numBits;
    private final int startBit;

    public BitStream(LongArray data, long start, int startBit, int numBits) {
        this.data = data;
        this.start = start;
        this.currPos = 0L;
        this.numBits = numBits;
        this.startBit = startBit;
        this.currLong = data.get(start) << startBit;
        this.relBit = startBit;
    }

    public boolean nextBit() {
        assert (!this.finished());
        if (this.relBit == 64) {
            this.advanceToNextLong();
        }
        boolean ret = (this.currLong & Long.MIN_VALUE) != 0L;
        ++this.relBit;
        this.currLong <<= 1;
        if (this.relBit == 64) {
            this.advanceToNextLong();
        }
        return ret;
    }

    public int nextConsecutiveZeros() {
        int numLeft;
        int numberOfLeadingZerosOnThisWord = Long.numberOfLeadingZeros(this.currLong);
        if (numberOfLeadingZerosOnThisWord >= (numLeft = 64 - this.relBit)) {
            this.advanceToNextLong();
            int numberOfLeadingZerosOnNextWord = Long.numberOfLeadingZeros(this.currLong);
            this.advanceWithinCurrLong(numberOfLeadingZerosOnNextWord + 1);
            return numberOfLeadingZerosOnNextWord + 1 + numLeft;
        }
        int headerLength = numberOfLeadingZerosOnThisWord + 1;
        this.advanceWithinCurrLong(headerLength);
        return headerLength;
    }

    public long next(int n) {
        assert (n <= 64);
        assert (!this.finished());
        int leftOnThisWord = Math.min(n, 64 - this.relBit);
        int onNextWord = n - leftOnThisWord;
        int thisWordShift = 64 - leftOnThisWord;
        long ret = this.currLong >>> thisWordShift;
        if (onNextWord > 0) {
            this.advanceToNextLong();
            int nextWordShift = 64 - onNextWord;
            ret <<= onNextWord;
            ret |= this.currLong >>> nextWordShift;
            this.advanceWithinCurrLong(onNextWord);
        } else {
            this.advanceWithinCurrLong(leftOnThisWord);
        }
        return ret;
    }

    private void advanceWithinCurrLong(int n) {
        assert (this.relBit + n <= 64);
        this.relBit += n;
        this.currLong <<= n;
    }

    private void advanceToNextLong() {
        ++this.currPos;
        this.relBit = 0;
        this.currLong = this.data.get(this.start + this.currPos);
    }

    public boolean finished() {
        return this.numBitsLeft() <= 0;
    }

    public void rewind(int i) {
        this.shiftAbsPosition(-i);
    }

    private void shiftAbsPosition(int i) {
        long absBit = (this.currPos << (int)LOG_LONG_SIZE) + (long)this.relBit;
        long rewound = absBit + (long)i;
        int newRelBit = (int)(rewound & LOG_LONG_MASK);
        long newPos = rewound >>> (int)LOG_LONG_SIZE;
        this.reset(newRelBit, newPos);
    }

    private void reset(int newRelBit, long newPos) {
        this.relBit = newRelBit;
        this.currPos = newPos;
        this.currLong = this.data.get(this.start + this.currPos) << this.relBit;
    }

    public int numBitsLeft() {
        return (int)((long)(this.numBits + this.startBit) - ((this.currPos << (int)LOG_LONG_SIZE) + (long)this.relBit));
    }

    public void advance(int n) {
        this.shiftAbsPosition(n);
    }

    public void mark() {
        assert (this.markedCurrPos < 0L) : "Tried to double mark";
        this.markedCurrPos = this.currPos;
        this.markedRelBit = this.relBit;
    }

    public void rewindToMark() {
        this.reset(this.markedRelBit, this.markedCurrPos);
        this.markedCurrPos = -1L;
        this.markedRelBit = -1;
    }
}

