/* GrandPerspective, Version 3.5.0 
 *   A utility for Mac OS X that graphically shows disk usage. 
 * Copyright (C) 2005-2022, Erwin Bonsma 
 * 
 * This program is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by the Free 
 * Software Foundation; either version 2 of the License, or (at your option) 
 * any later version. 
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT 
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
 * more details. 
 * 
 * You should have received a copy of the GNU General Public License along 
 * with this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA. 
 */

#import "DirectoryViewDisplaySettings.h"

#import "PreferencesPanelControl.h"

@implementation DirectoryViewDisplaySettings

- (instancetype) init {
  NSUserDefaults  *ud = NSUserDefaults.standardUserDefaults;

  return [self initWithColorMappingKey: [ud stringForKey: DefaultColorMappingKey]
                       colorPaletteKey: [ud stringForKey: DefaultColorPaletteKey]
                              maskName: [ud stringForKey: MaskFilterKey]
                           maskEnabled: NO
                      showEntireVolume: [ud boolForKey: ShowEntireVolumeByDefaultKey]
                   showPackageContents: [ud boolForKey: ShowPackageContentsByDefaultKey]];
}

- (instancetype) initWithColorMappingKey:(NSString *)colorMappingKey
                         colorPaletteKey:(NSString *)colorPaletteKey
                                maskName:(NSString *)maskName
                             maskEnabled:(BOOL)maskEnabled
                        showEntireVolume:(BOOL)showEntireVolume
                     showPackageContents:(BOOL)showPackageContents {
  if (self = [super init]) {
    _colorMappingKey = [colorMappingKey retain];
    _colorPaletteKey = [colorPaletteKey retain];
    _maskName = [maskName retain];
    _fileItemMaskEnabled = maskEnabled;
    _showEntireVolume = showEntireVolume;
    _showPackageContents = showPackageContents;
  }

  return self;
}

- (void) dealloc {
  [_colorMappingKey release];
  [_colorPaletteKey release];
  [_maskName release];

  [super dealloc];
}

- (id) copyWithZone:(NSZone *)zone {
  return [[[self class] allocWithZone: zone] initWithColorMappingKey: _colorMappingKey
                                                     colorPaletteKey: _colorPaletteKey
                                                            maskName: _maskName
                                                         maskEnabled: _fileItemMaskEnabled
                                                    showEntireVolume: _showEntireVolume
                                                 showPackageContents: _showPackageContents];
}

+ (DirectoryViewDisplaySettings *)defaultSettings {
  return [[[DirectoryViewDisplaySettings alloc] init] autorelease];
}

@end
