# -*- cmake -*-

# Copied from http://code.google.com/p/emeraldviewer/

# - Find libgcrypt
# Find the libgcrypt includes and library
# This module defines
#  LIBGCRYPT_INCLUDE_DIR, where to find gcrypt.h, etc.
#  LIBGCRYPT_LIBRARIES, the libraries needed to use libgcrypt.
#  LIBGCRYPT_FOUND, If false, do not try to use libgcrypt.
# also defined, but not for general use are
#  LIBGCRYPT_LIBRARY, where to find the libgcrypt library.

FIND_PATH(LIBGCRYPT_INCLUDE_DIR gcrypt.h)

SET(LIBGCRYPT_NAMES ${LIBGCRYPT_NAMES} gcrypt)
FIND_LIBRARY(LIBGCRYPT_LIBRARY
  NAMES ${LIBGCRYPT_NAMES}
  )

IF (LIBGCRYPT_LIBRARY AND LIBGCRYPT_INCLUDE_DIR)
    SET(LIBGCRYPT_LIBRARIES ${LIBGCRYPT_LIBRARY})
    SET(LIBGCRYPT_FOUND "YES")
ELSE (LIBGCRYPT_LIBRARY AND LIBGCRYPT_INCLUDE_DIR)
  SET(LIBGCRYPT_FOUND "NO")
ENDIF (LIBGCRYPT_LIBRARY AND LIBGCRYPT_INCLUDE_DIR)


IF (LIBGCRYPT_FOUND)
   IF (NOT LIBGCRYPT_FIND_QUIETLY)
      MESSAGE(STATUS "Found libgcrypt: '${LIBGCRYPT_LIBRARIES}' and header in '${LIBGCRYPT_INCLUDE_DIR}'")
   ENDIF (NOT LIBGCRYPT_FIND_QUIETLY)
ELSE (LIBGCRYPT_FOUND)
   IF (LIBGCRYPT_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR "Could not find libgcrypt library")
   ENDIF (LIBGCRYPT_FIND_REQUIRED)
ENDIF (LIBGCRYPT_FOUND)

# Deprecated declarations.
SET (NATIVE_LIBGCRYPT_INCLUDE_PATH ${LIBGCRYPT_INCLUDE_DIR} )
GET_FILENAME_COMPONENT (NATIVE_LIBGCRYPT_LIB_PATH ${LIBGCRYPT_LIBRARY} PATH)

MARK_AS_ADVANCED(
  LIBGCRYPT_LIBRARY
  LIBGCRYPT_INCLUDE_DIR
  )
