
/* AssignmentTracker X http://www.atxproject.net - (c) 2003-2006, Colin Wheeler ( colin@atxproject.net )
 * AXStartupWizard.m Created by Colin Wheeler on June 8, 2006
 * 
 * Contributor(s):
 *	Colin Wheeler
 * 
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU
 * General Public License version 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
 * Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with this program; if not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#import "ATXStartupWizardController.h"

/* What do you think this does? comment it out if you don't 
 * want so many descriptive messages about whats going on
 **/
#ifndef VERBOSE_MODE
#define VERBOSE_MODE
#endif

@implementation ATXStartupWizardController

#pragma mark -
#pragma mark Init and Accessor Methods

- (id)init
{
	nc = [NSNotificationCenter defaultCenter];
	
	paneCounter = 0;
	
	return self;
}

- (void)awakeFromNib
{
	/* Set the first view in the presentation NSBox */
	[presentationBox setContentView:introView];
	/* Disable the previous button */
	[prevButton setEnabled:NO];
	/* This will help later on for helping show newly created courses */
	[coursesController setSelectsInsertedObjects:YES];
}

- (NSManagedObjectContext *)managedObjectContext
{
	return [[[NSApplication sharedApplication] delegate] managedObjectContext];
}

#pragma mark -
#pragma mark Startup Wizard Methods

- (IBAction)goToNextPane:(id)sender
{
#ifdef VERBOSE_MODE
	NSLog(@"[ATXStartupWizardController] incrementing pane counter... now at: %i",paneCounter);
#endif
	paneCounter++;
#ifdef VERBOSE_MODE
	NSLog(@"[ATXStartupWizardController] incremented to: %i",paneCounter);
#endif
	
	//BOOL userAndSchoolIsValid; //this will be used in the user pane later on
	
	if(![prevButton isEnabled]) 
	{
		[prevButton setEnabled:YES];
		NSLog(@"[ATXStartupWizardController] Disabling Prev button");
	}
	switch (paneCounter) {
		case 1:
			[presentationBox setContentView:courseView];
			break;
		case 2:
			/* Make sure that we've created at least one course object
			 * before moving on*/
			if ( [[coursesController arrangedObjects] count] == 0 ) {
				//thanks for trying but that wasn't the answer we were looking for
				NSBeep();
				NSRunAlertPanel(@"You must create at least one course!",
								@"You must create at least one course before moving onto the next step. Please fill out the appropriate information",
								@"Ok",
								nil,
								nil);
				paneCounter--; // wax on wax off
				break;
			}
			//don't worry this will just create a NSManagedObject you can actually use in the next pane
			[[self managedObjectContext] processPendingChanges];
			[self performUserObjectCheck];
			[presentationBox setContentView:userView];
			break;
		case 3:
			//for now the validation code is buggy so we'll remove it
			/* userAndSchoolIsValid = [self validateUserNameAndSchool];
			if ( userAndSchoolIsValid == NO ) {
				NSBeep();
				NSRunAlertPanel(@"Please provide a name and school",
								@"Please provide your name and school so AssigmmentTracker X can customize reports for you",
								@"Ok",
								nil,
								nil);
				paneCounter--; //wax on wax off
				break;
			} */
			[presentationBox setContentView:finishedView];
			[nextButton setTitle:@"Continue"];
			break;
		case 4:
			[nc postNotificationName:@"STARTUP_WIZARD_DONE" 
							  object:nil];
	}
}

- (IBAction)goToPrevPane:(id)sender
{
	if (paneCounter == 0) {
		NSBeep();
	} else {
#ifdef VERBOSE_MODE
		NSLog(@"[ATXStartupWizardController] decrementing pane counter... now at: %i",paneCounter);
#endif
		paneCounter--;
#ifdef VERBOSE_MODE
		NSLog(@"[ATXStartupWizardController] decremented to %i",paneCounter);
#endif
	}
	if (![nextButton isEnabled]) {
		[nextButton setEnabled:YES];
	}
	switch (paneCounter) {
		case 0:
#ifdef VERBOSE_MODE
			NSLog(@"[ATXStartupWizardController] Setting Intro View...");
#endif
			[presentationBox setContentView:introView];
			[prevButton setEnabled:NO];
#ifdef VERBOSE_MODE
			NSLog(@"[ATXStartupWizardController] Disabled Prev button");
#endif
			break;
		case 1:
#ifdef VERBOSE_MODE
			NSLog(@"[ATXStartupWizardController] Setting Course View...");
#endif
			[presentationBox setContentView:courseView];
			break;
		case 2:
#ifdef VERBOSE_MODE
			NSLog(@"[ATXStartupWizardController] Setting User View...");
#endif
			[presentationBox setContentView:userView];
			break;
	}
}

/* Do a quick check to see if the user entity has an instance
 * if not quickly alloc one and let the user edit it */
- (void)performUserObjectCheck
{
	if(([userController selection] == NSNoSelectionMarker) || ([userController content] == nil)) {
#ifdef VERBOSE_MODE
		NSLog(@"[ATXStartupWizardController] No User NSManagedObject Exists...Creating one...");
#endif
		[userController newObject];
	}
}

- (BOOL)validateUserNameAndSchool
{
	/* We'll just make sure the user has actually entered something */
	NSManagedObject *userObject = [[userController selectedObjects] objectAtIndex:0];
	
	if ( [[userObject valueForKey:@"firstName"] isEqualToString:@"firstName"] ) {
		NSLog(@"[ATXStartupWizardController] First Name value is invalid (unchanged from default)");
		return NO;
	}
	else if ( [[userObject valueForKey:@"lastName"] isEqualToString:@"lastName"] ) {
		NSLog(@"[ATXStartupWizardController] Last Name value is invalid (unchanged from default)");
		return NO;
	} 
	else if ( [[userObject valueForKey:@"schoolName"] isEqualToString:@"schoolName"] ) {
		NSLog(@"[ATXStartupWizardController] School Name value is invalid (unchanged from default)");
		return NO;
	}
	return YES;
}

/** Adds a new course, selects the new course, and prepares the fields for editing.
	For some reason here we have to send processPendingChanges] to the NSManagedObjectContext 
*/
- (IBAction)beginAddingNewCourse:(id)sender
{
	/* This method is here so that in the future I can attempt
	 * to force the coursesNameTextField to begin editing after
	 * someone has added a course - sparing the user from having to
	 * do it themselves - right now I can't get it working 
	 *
	 * Wheres Doctor Tiki to help solve a problem when you need him?
	 */
	[coursesController add:self];
	[courseNameTextField setStringValue:@"new course name"];
	[courseNameTextField selectAll:self];
	//select new course
	[coursesController setSelectionIndex:[[coursesController arrangedObjects] count]];
	
	[[self managedObjectContext] processPendingChanges]; //hey wake up! we made some changes!
}

@end
