
/* AssignmentTracker X http://www.atxproject.net - (c) 2003-2006, Colin Wheeler ( colin@atxproject.net )
 * ATXStartupWizard.h Created by Colin Wheeler on June 8, 2006
 * 
 * Contributor(s):
 *	Colin Wheeler
 * 
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU
 * General Public License version 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
 * Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with this program; if not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#import <Cocoa/Cocoa.h>

@interface ATXStartupWizardController : NSObject {
	NSNotificationCenter *nc;
	//
	IBOutlet NSWindow *documentWindow;
	//
	IBOutlet NSView *introView;           // Introduction View
	IBOutlet NSView *userView;            // User Information View
	IBOutlet NSView *courseView;          // Course Setup/Edit/Delete View
	IBOutlet NSView *weightsView;
	IBOutlet NSView *finishedView;
	//
	IBOutlet NSObjectController *userController;
	//
	IBOutlet NSBox *presentationBox;      // Load our NSViews here
	//
	IBOutlet NSButton *nextButton;
	IBOutlet NSButton *prevButton;
	//
	int paneCounter;                      // To keep track of which step we are on in the wizard
	//
	IBOutlet NSWindow *courseSheet;
	IBOutlet NSArrayController *coursesController;
	IBOutlet NSTextField *courseNameTextField;
	IBOutlet NSTableView *courseTableView;
}
- (NSManagedObjectContext *)managedObjectContext;
//
- (IBAction)goToNextPane:(id)sender;
- (IBAction)goToPrevPane:(id)sender;
//
- (void)performUserObjectCheck;
- (BOOL)validateUserNameAndSchool;
//
- (IBAction)beginAddingNewCourse:(id)sender;
@end
