
/* AssignmentTracker X http://www.atxproject.net - (c) 2003-2006, Colin Wheeler ( colin@atxproject.net )
 * AXSplitViewDelegate.m Created by Colin Wheeler on March 26, 2006
 * 
 * Contributor(s):
 *	Colin Wheeler
 * 
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU
 * General Public License version 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
 * Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with this program; if not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/**
 * AXSplitViewDelegate is the delegate of the RBSplitView which is used on the primary window through which 
 * all views are loaded. The RBSplitView forms the divide between the source list on the left and the 
 * presentation frame to the right. It's responsible for for implementing a single delegate method for 
 * extending the drag region onto the imageview so the user has a very visible object for dragging the split
 */

#import "ATXSplitViewDelegate.h"
#import "ATXAboutBoxController.h"


@implementation ATXSplitViewDelegate

- (id)init 
{	
	return self;
}

- (void)awakeFromNib
{
	[splitView setDelegate:self];
}

// This makes it possible to drag the first divider around by the dragView.
- (unsigned int)splitView:(RBSplitView*)sender dividerForPoint:(NSPoint)point inSubview:(RBSplitSubview*)subview {
	if (subview==navigationSplit)
	{
		if ([dragView mouse:[dragView convertPoint:point fromView:sender] inRect:[dragView bounds]]) 
		{
			return 0;	// [navigationSplit position], which we assume to be zero
		}
	}
	return NSNotFound;
}

@end
