
/* AssignmentTracker X http://www.atxproject.net - (c) 2003-2006, Colin Wheeler ( colin@atxproject.net )
 * AXSourceDragController.h Created by Colin Wheeler on March 12, 2006
 * 
 * Contributor(s):
 *	Colin Wheeler
 * 
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU
 * General Public License version 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
 * Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with this program; if not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#import <Cocoa/Cocoa.h>

#import "ATXOutlineView.h"

// Kudos to Matt Holiday and his Drag and Drop Outline Edit example
//http://homepage.mac.com/matthol2/cocoa/page2/files/DragAndDropOutlineEdit.zip

@interface _NSControllerTreeProxy : NSObject 
{
	// opaque
}
//
// Number of objects at the root level.
//
- (unsigned int)count;

- (id)nodeAtIndexPath:(id)fp8;
- (id)objectAtIndexPath:(id)fp8;
@end

@interface _NSArrayControllerTreeNode : NSObject
{
	// opaque
}
- (unsigned int)count;
- (id)observedObject;
- (id)parentNode;
- (id)nodeAtIndexPath:(id)fp8;
- (id)subnodeAtIndex:(unsigned int)fp8;
- (BOOL)isLeaf;
- (id)indexPath;
- (id)objectAtIndexPath:(id)fp8;
@end

// some more detailed reverse engineering is available here
// http://www.blueboxmoon.com/wiki/?page=Binding%20Tree


@interface ATXSourceDragController : NSObject
{
	NSNotificationCenter *nc;
	IBOutlet NSTreeController *groupTreeControl;
	IBOutlet ATXOutlineView *treeTable;
	IBOutlet NSTableColumn *tbColumn;
		
	NSArray* dragType;
		
	_NSArrayControllerTreeNode* draggedNode;
	
	
}

- (void) resortGroups:(NSManagedObjectContext*)objectContext forParent:(NSManagedObject*)parent;
- (NSArray* ) getSubGroups:(NSManagedObjectContext*)objectContext forParent:(NSManagedObject*)parent;

@end

#define INTERVAL 10

