
/* AssignmentTracker X http://www.atxproject.net - (c) 2003-2006, Colin Wheeler ( colin@atxproject.net )
 * ATXPresentationManager.h Created by Colin Wheeler on July 12, 2006
 * 
 * Contributor(s):
 *	Colin Wheeler
 * 
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU
 * General Public License version 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
 * Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with this program; if not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/**
 * AXPresentation manager is responsible for managing the views presented in the MainMenu.nib
 */

#import "ATXPresentationManager.h"

#ifndef VERBOSE_MODE
#define VERBOSE_MODE
#endif

@implementation ATXPresentationManager

- (id)init
{
	/* Initialize our variables */
	nc = [NSNotificationCenter defaultCenter];
	
	/* Subscribe to the appropriate notifications */
	
	/* New Document created, present Startup Wizard */
	[nc addObserver:self 
		   selector:@selector(presentStartupWizard)
			   name:@"SHOW_STARTUP_WIZARD" 
			 object:nil];
	/* Startup Wizard is done, present default assignments view */
	[nc addObserver:self
		   selector:@selector(exitStartupWizardAndGoToMainWindow)
			   name:@"STARTUP_WIZARD_DONE" 
			 object:nil];
	/* Normal Startup, present default assignments view */
	[nc addObserver:self
		   selector:@selector(presentAssignmentsView) 
			   name:@"SHOW_ASSIGNMENTS_VIEW" 
			 object:nil];
	
	return self;
}

- (void)loadTheNib:(NSString *)nameOfNib withTestConnection:(NSView *)testView
{
	if (testView == nil) 
	{
#ifdef VERBOSE_MODE
		NSLog(@"[ATXPresentationManager] Test View is nil...Loading Nib...");
#endif
		
		NSNib *nib = [[NSNib alloc] initWithNibNamed:nameOfNib bundle:[NSBundle bundleForClass:[self class]]];
		
		BOOL success = [nib instantiateNibWithOwner:self topLevelObjects:nil];
		[nib release];
		if (success != YES) 
		{
#ifdef VERBOSE_MODE
			[NSAlert alertWithMessageText:@"Error! Couldn't Load Nib!" 
						    defaultButton:@"Ok" 
						  alternateButton:nil 
							  otherButton:nil 
				informativeTextWithFormat:nil];
#endif
			NSLog(@"Error loading Nib: %@",nameOfNib);
			return;
		}
	}
}

- (void)presentStartupWizard
{
	NSLog(@"[ATXPresentationManager] Received Startup Wizard Notification");
	NSLog(@"[ATXPresentationManager] Setting Startup Wizard as content view...");
	[self loadTheNib:@"StartupWizard" withTestConnection:startupWizardView];
	[presentationBox setContentView:startupWizardView];
}

- (void)exitStartupWizardAndGoToMainWindow
{
	/* Let MyDocument finish initializing now that everythings setup */
	[nc postNotificationName:@"ATXCORECONTROLLER_FINISH_SETUP"
					  object:nil];
	
	NSLog(@"[ATXPresentationManager] Received Startup Wizard Completion Notification");
	[self presentAssignmentsView];
}

- (void)presentAssignmentsView
{
	NSLog(@"[ATXPresentationManager] Setting Assignment Table as content view...");
	[presentationBox setContentView:allAssignmentsView];
}

@end
