
/* AssignmentTracker X http://www.atxproject.net - (c) 2003-2006, Colin Wheeler ( colin@atxproject.net )
 * AXOutlineView.h Created by Colin Wheeler on March 12, 2006
 * 
 * Contributor(s):
 *	Colin Wheeler
 * 
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU
 * General Public License version 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
 * Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with this program; if not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#import <Cocoa/Cocoa.h>

@interface ATXOutlineView : NSOutlineView
{
	NSIndexSet *draggedRows;
	
	BOOL usesGradientSelection;
	BOOL selectionGradientIsContiguous;
	BOOL usesDisabledGradientSelectionOnly;
	BOOL hasBreakBetweenGradientSelectedRows;
}

/* Useful for delegate when deciding how to colour text */
- (NSIndexSet *)draggedRows;

	// Gradient selection methods
	/* Sets whether the outline view should use gradient selection bars. */
- (void)setUsesGradientSelection:(BOOL)flag;
- (BOOL)usesGradientSelection;

	/* Sets whether gradient selections should be contiguous across multiple
	rows. (iTunes and Mail don't have this, but I think it looks better.) */
- (void)setSelectionGradientIsContiguous:(BOOL)flag;
- (BOOL)selectionGradientIsContiguous;

	/* Sets whether the selection should always look disabled (grey), even
	when the outline view has the focus (like in Mail) */
- (void)setUsesDisabledGradientSelectionOnly:(BOOL)flag;
- (BOOL)usesDisabledGradientSelectionOnly;

	/* Sets whether selected rows have a pixel gap between them that is the
	background colour rather than the selection colour */
- (void)setHasBreakBetweenGradientSelectedRows:(BOOL)flag;
- (BOOL)hasBreakBetweenGradientSelectedRows;

////////////////
// EXPERIMENTAL CODE
////////////////
//- (id)observedObjectForItem:(id)item;
//- (NSArray *)expandedState;
//- (BOOL)restoreExpandedStateWithArray:(NSArray *)stateArray;
@end
//
//@interface NSObject (KBOutlineViewDataSource)
//- (id)outlineView:(NSOutlineView *)outlineView uniqueValueForObservedObject:(id)observedObject;
//@end
