
/* AssignmentTracker X http://www.atxproject.net - (c) 2003-2006, Colin Wheeler ( colin@atxproject.net )
 * ATXLicenseWindowController.m Created by Colin Wheeler on November 17, 2006
 * 
 * Contributor(s):
 *	Colin Wheeler
 * 
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU
 * General Public License version 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
 * Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with this program; if not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#import "ATXLicenseWindowController.h"

/**
 * ATXLicenseWindowController is responsible to loading, presenting and printing the GNU General Public License
 * in a WebKit view
 */

@implementation ATXLicenseWindowController

ATXLicenseWindowController *sharedLicenseControllerInstance = nil;

+ (ATXLicenseWindowController *)sharedLicenseController
{
	if (!sharedLicenseControllerInstance) {
		sharedLicenseControllerInstance = [[self alloc] initWithWindowNibName:@"License"];
	}
	return (sharedLicenseControllerInstance);
}

- (id)initWithWindowNibName:(NSString *)windowNibName
{
    [super initWithWindowNibName:@"License"];
    return(self);
}

- (void)dealloc
{    
    [super dealloc];
}

- (void)windowDidLoad
{
	[[licenseView mainFrame] loadRequest:[NSURLRequest requestWithURL:[NSURL fileURLWithPath:[[NSBundle mainBundle] pathForResource:@"GPL.html" 
																															 ofType:nil]]]];
}

- (IBAction)printLicenseContents:(id)sender
{
	NSPrintInfo *printInfo = [NSPrintInfo sharedPrintInfo];
	NSPrintOperation *printOperation;
	
	/* You cannot just print the contents of the WebViews frame if you 
	 * do you will only print the visible bounds of the view ( yes this 
     * is stupid ) You must create a pointer to it's web document view
	 */
	
	NSView *webView = [[[licenseView mainFrame] frameView] documentView];
	
	[printInfo setTopMargin:15.0];
	[printInfo setLeftMargin:10.0];
	[printInfo setRightMargin:10.0];
	[printInfo setBottomMargin:15.0];
	
	[printInfo setHorizontallyCentered:NO];
	[printInfo setVerticallyCentered:NO];
	
	printOperation = [NSPrintOperation printOperationWithView:webView 
													printInfo:printInfo];
	
	[printOperation setShowPanels:YES];
	[printOperation runOperation];
}

@end
