
/* AssignmentTracker X http://www.atxproject.net - (c) 2003-2006, Colin Wheeler ( colin@atxproject.net )
 * ATXAboutBoxController.m Created by Colin Wheeler on Aril 30, 2005
 * 
 * Contributor(s):
 *	Colin Wheeler
 * 
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU
 * General Public License version 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
 * Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with this program; if not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#import "ATXAboutBoxController.h"

#define ABOUT_SCROLL_FPS 24.0

@implementation ATXAboutBoxController

ATXAboutBoxController *sharedAboutBoxInstance = nil;

+ (ATXAboutBoxController *)aboutBoxController
{
	if(!sharedAboutBoxInstance)
	{
        sharedAboutBoxInstance = [[self alloc] initWithWindowNibName:@"AboutBox"];
    }
    return(sharedAboutBoxInstance);
}

- (id)initWithWindowNibName:(NSString *)windowNibName
{
    [super initWithWindowNibName:@"AboutBox"];
    return(self);
}

- (void)dealloc
{    
    [super dealloc];
}

- (void)loadAppVersion
{
	NSDictionary *appDict = [[NSBundle mainBundle] infoDictionary];
	[versionField setStringValue:[appDict objectForKey:@"CFBundleVersion"]];
}

- (void)windowDidLoad
{
    NSAttributedString		*creditsString;
    
    //Grab & set the version field string
	[self loadAppVersion];
	
    //Setting Credits...
    creditsString = [[[NSAttributedString alloc] initWithPath:[[NSBundle mainBundle] pathForResource:@"Credits.rtf" ofType:nil] documentAttributes:nil] autorelease];
    [[creditsView textStorage] setAttributedString:creditsString];
    [[creditsView enclosingScrollView] setLineScroll:0.0];
    [[creditsView enclosingScrollView] setPageScroll:0.0];
    
    //Start the scrolling...  
    scrollLocation = 0; 
    scrollRate = 1.0;
    maxScroll = [[creditsView textStorage] size].height - [[creditsView enclosingScrollView] documentVisibleRect].size.height;
    scrollTimer = [[NSTimer scheduledTimerWithTimeInterval:(1.0/ABOUT_SCROLL_FPS)
													target:self
												  selector:@selector(scrollTimer:)
												  userInfo:nil
												   repeats:YES] retain];
	eventLoopScrollTimer = [[NSTimer timerWithTimeInterval:(1.0/ABOUT_SCROLL_FPS)
													target:self
												  selector:@selector(scrollTimer:)
												  userInfo:nil
												   repeats:YES] retain];
    
    [[self window] center];
}

- (void)scrollTimer:(NSTimer *)scrollTimer
{    
	scrollLocation += scrollRate;
	
	if(scrollLocation > maxScroll) scrollLocation = 0;    
	if(scrollLocation < 0) scrollLocation = maxScroll;
	
	[creditsView scrollPoint:NSMakePoint(0, scrollLocation)];
}

- (IBAction)closeWindow:(id)sender
{
    if([self windowShouldClose:nil]){
        [[self window] close];
    }
}

- (BOOL)windowShouldClose:(id)sender
{
    [sharedAboutBoxInstance autorelease]; sharedAboutBoxInstance = nil;
    [scrollTimer invalidate]; [scrollTimer release]; scrollTimer = nil;
	[eventLoopScrollTimer invalidate]; [eventLoopScrollTimer release]; eventLoopScrollTimer = nil;
	
    return(YES);
}

- (IBAction)visitHomepage:(id)sender
{
    [[NSWorkspace sharedWorkspace] openURL:[NSURL URLWithString:@"http://www.atxproject.net"]];
}

- (IBAction)donateToATX:(id)sender
{
	[[NSWorkspace sharedWorkspace] openURL:[NSURL URLWithString:@"https://www.paypal.com/xclick/business=atxproject%40gmail.com&item_name=AssignmentTracker+X+Project&no_note=1&tax=0&currency_code=USD&lc=US"]];
}

@end
