
/* AssignmentTracker X http://www.atxproject.net - (c) 2003-2006, Colin Wheeler ( colin@atxproject.net )
 * AXAboutBoxController.m Created by Colin Wheeler on Aril 30, 2005
 * 
 * Contributor(s):
 *	Colin Wheeler
 * 
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU
 * General Public License version 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
 * Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with this program; if not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

//!  AXAboutBoxController.
/*!
 AXAboutBoxController is a class based on Adium's LNAboutBoxController 
 with some tweaks and is designed to display everything all at once in
 the about box (minus the credits field of course) in a simplistic
 interface, setting options in Interface Builder whenever possible
 */

#import <Cocoa/Cocoa.h>

@interface ATXAboutBoxController : NSWindowController {
	IBOutlet NSTextView *creditsView;      /**< Displays the Credits.rtf file */
	IBOutlet NSTextField *versionField;    /**< Displays the App Version String */
	NSTimer *scrollTimer;                  /**< Timer for */
	NSTimer *eventLoopScrollTimer;         /**< Timer for */
    float    scrollLocation;               /**< Location on the scrollvar in the Credits View */
    int      maxScroll;                    /**< Max Scroll Length */
    float    scrollRate;                   /**< Predefined Scroll Rate for credits view */
}
/** Returns a shared instance of the AboutBoxController Class */
+ (ATXAboutBoxController *)aboutBoxController;
/** Action for visiting atxproject.net from the About box */
- (IBAction)visitHomepage:(id)sender;
/** Grabs the App Info version (CFBundleVersion) from the App Info Dictionary */
- (void)loadAppVersion;
/** Sends user to paypal donation page */
- (IBAction)donateToATX:(id)sender;
@end
