/*
 This file is part of GNU Taler
 (C) 2019 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import * as hostImpl from "#host-impl";
import { DefaultNodeWalletArgs } from "./host-common.js";
import { Wallet } from "./index.js";

/**
 * Helpers to initiate a wallet in a host environment.
 */

/**
 * Get a wallet instance.
 */
export async function createNativeWalletHost2(
  args: DefaultNodeWalletArgs = {},
): Promise<{
  wallet: Wallet;
}> {
  return hostImpl.createNativeWalletHost2(args);
}

/**
 * Get a wallet instance.
 */
export async function createNativeWalletHost(
  args: DefaultNodeWalletArgs = {},
): Promise<Wallet> {
  const res = await hostImpl.createNativeWalletHost2(args);
  return res.wallet;
}
