/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.widget.DatePicker;
import android.widget.ProgressBar;
import android.widget.SlidingDrawer;
import android.widget.TimePicker;
import com.jayway.android.robotium.solo.ActivityUtils;

class Setter {
    private final int CLOSED = 0;
    private final int OPENED = 1;
    private final ActivityUtils activityUtils;

    public Setter(ActivityUtils activityUtils) {
        this.activityUtils = activityUtils;
    }

    public void setDatePicker(final DatePicker datePicker, final int year, final int monthOfYear, final int dayOfMonth) {
        if (datePicker != null) {
            this.activityUtils.getCurrentActivity(false).runOnUiThread(new Runnable(){

                public void run() {
                    try {
                        datePicker.updateDate(year, monthOfYear, dayOfMonth);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public void setTimePicker(final TimePicker timePicker, final int hour, final int minute) {
        if (timePicker != null) {
            this.activityUtils.getCurrentActivity(false).runOnUiThread(new Runnable(){

                public void run() {
                    try {
                        timePicker.setCurrentHour(Integer.valueOf(hour));
                        timePicker.setCurrentMinute(Integer.valueOf(minute));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public void setProgressBar(final ProgressBar progressBar, final int progress) {
        if (progressBar != null) {
            this.activityUtils.getCurrentActivity(false).runOnUiThread(new Runnable(){

                public void run() {
                    try {
                        progressBar.setProgress(progress);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public void setSlidingDrawer(final SlidingDrawer slidingDrawer, final int status) {
        if (slidingDrawer != null) {
            this.activityUtils.getCurrentActivity(false).runOnUiThread(new Runnable(){

                public void run() {
                    try {
                        switch (status) {
                            case 0: {
                                slidingDrawer.close();
                                break;
                            }
                            case 1: {
                                slidingDrawer.open();
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }
}

