// rc.cpp:  "Run Command" configuration file, for Gnash.
// 
//   Copyright (C) 2005, 2006, 2007, 2008 Free Software Foundation, Inc.
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//

// This is generated by autoconf
#ifdef HAVE_CONFIG_H
# include "gnashconfig.h"
#endif

#include "StringPredicates.h"
#include "log.h"
#include "crc.h"

#ifdef HAVE_PWD_H
# include <pwd.h>
#endif

#include <sys/types.h>
#include <unistd.h> // for getuid()
#include <sys/stat.h>
#include <boost/cstdint.hpp>

#include <cctype>  // for toupper
#include <string>
#include <vector>
#include <iostream>
#include <fstream>

using namespace std;
using namespace gnash;

namespace cygnal {

CRcInitFile&
CRcInitFile::getDefaultInstance()
{
	// TODO: allocate on the heap and provide a destroyDefaultInstance,
	//       for finer control of destruction order
	static CRcInitFile crcfile;
	return crcfile;
}


CRcInitFile::CRcInitFile() : _port_offset(0)
{
//    GNASH_REPORT_FUNCTION;
    loadFiles();
}

CRcInitFile::~CRcInitFile()
{
//    GNASH_REPORT_FUNCTION;    
}

// Look for a config file in the likely places.
bool
CRcInitFile::loadFiles()
{
//    GNASH_REPORT_FUNCTION;
    
    // Check the default system location
    string loadfile = "/etc/cygnalrc";
    parseFile(loadfile);
    
    // Check the default config location
    loadfile = "/usr/local/etc/cygnalrc";
    parseFile(loadfile);
    
    // Check the users home directory
    char *home = getenv("HOME");
    if (home) {
        loadfile = home;
        loadfile += "/.cygnalrc";
        parseFile(loadfile);
    }

    // Check the GNASHRC environment variable
    char *cygnalrc = getenv("CYGNALRC");
    if (cygnalrc) {
        loadfile = cygnalrc;
        return parseFile(loadfile);
    }
    
    return false;
}


// Parse the config file and set the variables.
bool
CRcInitFile::parseFile(const std::string& filespec)
{
    GNASH_REPORT_FUNCTION;
    struct stat stats;
    string action;
    string variable;
    string value;
    ifstream in;

	StringNoCaseEqual noCaseCompare;
    
//  log_debug ("Seeing if %s exists", filespec);
    if (filespec.size() == 0) {
        return false;
    }
    
    if (stat(filespec.c_str(), &stats) == 0) {
        in.open(filespec.c_str());
        
        if (!in) {
            log_error(_("Couldn't open file: %s"), filespec.c_str());
            return false;
        }
        
        // Read in each line and parse it
        do {

	    // Make sure action is empty, otherwise the last loop (with no new
	    // data) keeps action, variable and value from the previous loop. This
	    // causes problems if set blacklist or set whitelist are last, because
	    // value is erased while parsing and the lists are thus deleted.
	    action.clear();

            // Get the first token
            in >> action;

            // Ignore comment lines
            if (action[0] == '#') {
                // suck up the rest of the line
                char name[128];
                in.getline(name, 128);
                continue;
            } 
            
	    // Get second token
            in >> variable;

            // cout << "Parsing " << variable << endl;

	    // Read in rest of line for parsing.
            getline(in, value);

	    // Erase leading spaces.
            string::size_type position = value.find_first_not_of(' ');
            if(position != string::npos) value.erase(0, position);

            if (noCaseCompare(variable, "debuglog")) {
                expandPath (value);
                setDebugLog(value);
                continue;
            }

            if (noCaseCompare(variable, "documentroot") ) {
                setDocumentRoot(value);
                continue;
            }

            bool test;
            uint32_t num;

            if ( extractSetting(test, "actionDump", variable, value) )
                useParserDump(test);
            else if ( extractSetting(test, "parserDump", variable, value) )
                useActionDump(test);
            else if ( extractNumber(num, "verbosity", variable, value) )
                verbosityLevel(num);
            else extractNumber((uint32_t&)_port_offset, "portOffset", variable, value);

        } while (!in.eof());

    } else {
        if (in) {
            in.close();
        }
        return false;
    }  
    
    if (in) {
        in.close();
    }

    return true;
}

void
CRcInitFile::dump()
{
    cerr << endl << "Dump CRcInitFile:" << endl;
    cerr << "\tPort Offset: " << _port_offset << endl;

    RcInitFile::dump();
}

} // end of namespace cygnal
