
/*
 * Generated data (by mkcproc.pl)
 */
#line 1 "bsejanitor.proc"

#include <bse/bseplugin.h>
#include <bse/bseprocedure.h>
#include <bse/bsejanitor.h>
#include <bse/bseserver.h>
#include <string.h>


#line 27 "bsejanitor.proc"


/* --- trigger-action --- */
static void
trigger_action_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 29 "bsejanitor.proc"
 {
#line 31 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("action", "Action", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 36 "bsejanitor.proc"
 }
static BseErrorType
#line 36 "bsejanitor.proc"
trigger_action_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 39 "bsejanitor.proc"
{
#line 40 "bsejanitor.proc"
  
  BseJanitor  *self   = bse_value_get_object (in_values++);
  const gchar *action = sfi_value_get_string (in_values++);
  
#line 44 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self) || !action)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 48 "bsejanitor.proc"
  
  bse_janitor_trigger_action (self, action);
  
  return BSE_ERROR_NONE;
}

/* --- get-script-name --- */
static void
get_script_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 54 "bsejanitor.proc"
 {
#line 56 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_STANDARD);
  *(out_pspecs++)    = sfi_pspec_string ("script_name", "Script Name", NULL,
			     NULL, SFI_PARAM_STANDARD);
}
#line 61 "bsejanitor.proc"
 }
static BseErrorType
#line 61 "bsejanitor.proc"
get_script_name_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 64 "bsejanitor.proc"
{
#line 65 "bsejanitor.proc"
  
  BseJanitor *self = bse_value_get_object (in_values++);
  
#line 68 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 72 "bsejanitor.proc"
  
  sfi_value_set_string (out_values++, self->script_name);
  
  return BSE_ERROR_NONE;
}

/* --- get-proc-name --- */
static void
get_proc_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 78 "bsejanitor.proc"
 {
#line 80 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_STANDARD);
  *(out_pspecs++)    = sfi_pspec_string ("proc_name", "Proc Name", NULL,
			     NULL, SFI_PARAM_STANDARD);
}
#line 85 "bsejanitor.proc"
 }
static BseErrorType
#line 85 "bsejanitor.proc"
get_proc_name_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 88 "bsejanitor.proc"
{
#line 89 "bsejanitor.proc"
  
  BseJanitor *self = bse_value_get_object (in_values++);
  
#line 92 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 96 "bsejanitor.proc"
  
  sfi_value_set_string (out_values++, self->proc_name);
  
  return BSE_ERROR_NONE;
}

/* --- n-actions --- */
static void
n_actions_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 102 "bsejanitor.proc"
 {
#line 104 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("n_actions", "N Actions", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
}
#line 109 "bsejanitor.proc"
 }
static BseErrorType
#line 109 "bsejanitor.proc"
n_actions_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 112 "bsejanitor.proc"
{
#line 113 "bsejanitor.proc"
  
  BseJanitor *self = bse_value_get_object (in_values++);
  
#line 116 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 120 "bsejanitor.proc"
  
  sfi_value_set_int (out_values++, g_slist_length (self->actions));
  
  return BSE_ERROR_NONE;
}

/* --- get-action --- */
static void
get_action_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 126 "bsejanitor.proc"
 {
#line 128 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("nth_action", "Nth Action", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_string ("action", "Action", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 135 "bsejanitor.proc"
 }
static BseErrorType
#line 135 "bsejanitor.proc"
get_action_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 138 "bsejanitor.proc"
{
#line 139 "bsejanitor.proc"
  
  BseJanitor       *self = bse_value_get_object (in_values++);
  guint             nth  = sfi_value_get_int (in_values++);
  BseJanitorAction *a;
  
#line 144 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  a = g_slist_nth_data (self->actions, nth);
  
#line 150 "bsejanitor.proc"
  
  sfi_value_set_string (out_values++, a ? g_quark_to_string (a->action) : NULL);
  
  return BSE_ERROR_NONE;
}

/* --- get-action-name --- */
static void
get_action_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 156 "bsejanitor.proc"
 {
#line 158 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("nth_action", "Nth Action", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_string ("action-name", "Action Name", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 165 "bsejanitor.proc"
 }
static BseErrorType
#line 165 "bsejanitor.proc"
get_action_name_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 168 "bsejanitor.proc"
{
#line 169 "bsejanitor.proc"
  
  BseJanitor       *self = bse_value_get_object (in_values++);
  guint             nth  = sfi_value_get_int (in_values++);
  BseJanitorAction *a;
  
#line 174 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  a = g_slist_nth_data (self->actions, nth);
  
#line 180 "bsejanitor.proc"
  
  sfi_value_set_string (out_values++, a ? a->name : NULL);
  
  return BSE_ERROR_NONE;
}

/* --- get-action-blurb --- */
static void
get_action_blurb_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 186 "bsejanitor.proc"
 {
#line 188 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("nth_action", "Nth Action", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_string ("action-blurb", "Action Blurb", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 195 "bsejanitor.proc"
 }
static BseErrorType
#line 195 "bsejanitor.proc"
get_action_blurb_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 198 "bsejanitor.proc"
{
#line 199 "bsejanitor.proc"
  
  BseJanitor       *self = bse_value_get_object (in_values++);
  guint             nth  = sfi_value_get_int (in_values++);
  BseJanitorAction *a;
  
#line 204 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  a = g_slist_nth_data (self->actions, nth);
  
#line 210 "bsejanitor.proc"
  
  sfi_value_set_string (out_values++, a ? a->blurb : NULL);
  
  return BSE_ERROR_NONE;
}

/* --- kill --- */
static void
kill_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 216 "bsejanitor.proc"
 {
#line 218 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_STANDARD);
}
#line 221 "bsejanitor.proc"
 }
static BseErrorType
#line 221 "bsejanitor.proc"
kill_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 224 "bsejanitor.proc"
{
#line 225 "bsejanitor.proc"
  
  BseJanitor *self = bse_value_get_object (in_values++);
  
#line 228 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 232 "bsejanitor.proc"
  
  bse_janitor_kill (self);
  
  return BSE_ERROR_NONE;
}

/* --- bse-script-janitor --- */
static void
bse_script_janitor_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 238 "bsejanitor.proc"
 {
#line 240 "bsejanitor.proc"
  *(out_pspecs++)   = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_STANDARD);
}
#line 243 "bsejanitor.proc"
 }
static BseErrorType
#line 243 "bsejanitor.proc"
bse_script_janitor_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 246 "bsejanitor.proc"
{
  BseJanitor *self = bse_janitor_get_current ();
  
#line 249 "bsejanitor.proc"
  
  if (!self || !self->port || self->port_closed)
    return BSE_ERROR_PROC_EXECUTION;

#line 253 "bsejanitor.proc"
  
  bse_value_set_object (out_values++, self);
  
  return BSE_ERROR_NONE;
}

/* --- bse-script-add-action --- */
static void
bse_script_add_action_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 259 "bsejanitor.proc"
 {
#line 261 "bsejanitor.proc"
  *(in_pspecs++) = sfi_pspec_string ("action", "Action", NULL,
			    NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", NULL,
			    NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("blurb", "Blurb", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 268 "bsejanitor.proc"
 }
static BseErrorType
#line 268 "bsejanitor.proc"
bse_script_add_action_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 271 "bsejanitor.proc"
{
#line 272 "bsejanitor.proc"
  
  BseJanitor  *self   = bse_janitor_get_current ();
  const gchar *action = sfi_value_get_string (in_values++);
  const gchar *name   = sfi_value_get_string (in_values++);
  const gchar *blurb  = sfi_value_get_string (in_values++);
  
#line 278 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self) || !action || !name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 282 "bsejanitor.proc"
  
  if (!self->port || self->port_closed)
    return BSE_ERROR_PROC_EXECUTION;
  
#line 286 "bsejanitor.proc"
  
  bse_janitor_add_action (self, action, name, blurb);
  
  return BSE_ERROR_NONE;
}

/* --- bse-script-remove-action --- */
static void
bse_script_remove_action_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 292 "bsejanitor.proc"
 {
#line 294 "bsejanitor.proc"
  *(in_pspecs++) = sfi_pspec_string ("action", "Action", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 297 "bsejanitor.proc"
 }
static BseErrorType
#line 297 "bsejanitor.proc"
bse_script_remove_action_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 300 "bsejanitor.proc"
{
#line 301 "bsejanitor.proc"
  
  BseJanitor  *self   = bse_janitor_get_current ();
  const gchar *action = sfi_value_get_string (in_values++);
  
#line 305 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self) || !action)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 309 "bsejanitor.proc"
  
  if (!self->port || self->port_closed)
    return BSE_ERROR_PROC_EXECUTION;
  
#line 313 "bsejanitor.proc"
  
  bse_janitor_remove_action (self, action);
  
  return BSE_ERROR_NONE;
}

/* --- bse-script-set-status --- */
static void
bse_script_set_status_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 319 "bsejanitor.proc"
 {
#line 321 "bsejanitor.proc"
  *(in_pspecs++)    = sfi_pspec_string ("message", "Message", NULL,
			    NULL, SFI_PARAM_STANDARD);
#line 323 "bsejanitor.proc"
}  }
static BseErrorType
#line 323 "bsejanitor.proc"
bse_script_set_status_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 326 "bsejanitor.proc"
{
#line 327 "bsejanitor.proc"
  
  BseJanitor    *self    = bse_janitor_get_current ();
  const gchar   *message = sfi_value_get_string (in_values++);
  
#line 331 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 335 "bsejanitor.proc"
  
  if (!self->port || self->port_closed)
    return BSE_ERROR_PROC_EXECUTION;
  if (!message)
    message = "";
  
#line 341 "bsejanitor.proc"
  
  bse_item_set (self, "status-message", message, NULL);
  
  return BSE_ERROR_NONE;
}

/* --- bse-script-progress --- */
static void
bse_script_progress_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 347 "bsejanitor.proc"
 {
#line 349 "bsejanitor.proc"
  *(in_pspecs++)    = sfi_pspec_real ("progress", "Progress", NULL,
			  -1, -1, 1.0, 0.1,
			  SFI_PARAM_STANDARD);
#line 352 "bsejanitor.proc"
}  }
static BseErrorType
#line 352 "bsejanitor.proc"
bse_script_progress_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 355 "bsejanitor.proc"
{
#line 356 "bsejanitor.proc"
  
  BseJanitor *self = bse_janitor_get_current ();
  gfloat progress  = sfi_value_get_real (in_values++);
  
#line 360 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 364 "bsejanitor.proc"
  
  if (!self->port || self->port_closed)
    return BSE_ERROR_PROC_EXECUTION;
  
#line 368 "bsejanitor.proc"
  
  bse_janitor_progress (self, progress);
  
  return BSE_ERROR_NONE;
}

/* --- bse-script-send-message --- */
static void
bse_script_send_message_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 374 "bsejanitor.proc"
 {
#line 376 "bsejanitor.proc"
  
  *(in_pspecs++)    = sfi_pspec_string ("domain", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("msg-type", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("title", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("primary", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("secondary", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("details", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("config-check", NULL, NULL, NULL, SFI_PARAM_STANDARD);
#line 384 "bsejanitor.proc"
}  }
static BseErrorType
#line 384 "bsejanitor.proc"
bse_script_send_message_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 387 "bsejanitor.proc"
{
#line 388 "bsejanitor.proc"
  
  BseJanitor *janitor = bse_janitor_get_current();
  const gchar *domain = sfi_value_get_string (in_values++);
  const gchar *mtype  = sfi_value_get_string (in_values++);
  const gchar *text0  = sfi_value_get_string (in_values++);
  const gchar *text1  = sfi_value_get_string (in_values++);
  const gchar *text2  = sfi_value_get_string (in_values++);
  const gchar *text3  = sfi_value_get_string (in_values++);
  const gchar *check  = sfi_value_get_string (in_values++);
  SfiMsgType    type  = mtype ? sfi_msg_lookup_type (mtype) : 0;

#line 399 "bsejanitor.proc"
  
  if (!mtype || !(text1 || text2))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 403 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (janitor) || !janitor->port || janitor->port_closed)
    return BSE_ERROR_PROC_EXECUTION;

#line 407 "bsejanitor.proc"
  
  bse_server_message (bse_server_get (), domain, type, text0, text1, text2, text3, check, janitor, NULL, janitor->port->remote_pid);

  return BSE_ERROR_NONE;
}

/* --- bse-script-quit --- */
static void
bse_script_quit_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 413 "bsejanitor.proc"
 {
#line 415 "bsejanitor.proc"
}  }
static BseErrorType
#line 415 "bsejanitor.proc"
bse_script_quit_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 418 "bsejanitor.proc"
{
#line 419 "bsejanitor.proc"
  
  BseJanitor *janitor = bse_janitor_get_current();

#line 422 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (janitor) || !janitor->port || janitor->port_closed)
    return BSE_ERROR_PROC_EXECUTION;
  
#line 426 "bsejanitor.proc"
  
  janitor->force_normal_exit = TRUE;
  bse_janitor_close (janitor);
  
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_trigger_action__fill_strings (BseExportStrings *es)
{
  es->blurb = "Trigger an installed user action of this janitor.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 30;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_trigger_action = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseJanitor+trigger-action", 
    NULL,
    "/Methods/BseJanitor/General/Trigger Action",
    NULL,
    __enode_trigger_action__fill_strings,
  },
  0, trigger_action_setup, trigger_action_exec, 
};
static void
__enode_get_script_name__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the script name of this janitor.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 55;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_get_script_name = {
  { (BseExportNode*) &__enode_trigger_action, BSE_EXPORT_NODE_PROC,
    "BseJanitor+get-script-name", 
    NULL,
    "/Methods/BseJanitor/General/Get Script Name",
    NULL,
    __enode_get_script_name__fill_strings,
  },
  0, get_script_name_setup, get_script_name_exec, 
};
static void
__enode_get_proc_name__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the procedure name of this janitor.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 79;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_get_proc_name = {
  { (BseExportNode*) &__enode_get_script_name, BSE_EXPORT_NODE_PROC,
    "BseJanitor+get-proc-name", 
    NULL,
    "/Methods/BseJanitor/General/Get Proc Name",
    NULL,
    __enode_get_proc_name__fill_strings,
  },
  0, get_proc_name_setup, get_proc_name_exec, 
};
static void
__enode_n_actions__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve number of user actions of this janitor.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 103;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_n_actions = {
  { (BseExportNode*) &__enode_get_proc_name, BSE_EXPORT_NODE_PROC,
    "BseJanitor+n-actions", 
    NULL,
    "/Methods/BseJanitor/General/N Actions",
    NULL,
    __enode_n_actions__fill_strings,
  },
  0, n_actions_setup, n_actions_exec, 
};
static void
__enode_get_action__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve an action of this janitor.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 127;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_get_action = {
  { (BseExportNode*) &__enode_n_actions, BSE_EXPORT_NODE_PROC,
    "BseJanitor+get-action", 
    NULL,
    "/Methods/BseJanitor/General/Get Action",
    NULL,
    __enode_get_action__fill_strings,
  },
  0, get_action_setup, get_action_exec, 
};
static void
__enode_get_action_name__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the name of an action of this janitor.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 157;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_get_action_name = {
  { (BseExportNode*) &__enode_get_action, BSE_EXPORT_NODE_PROC,
    "BseJanitor+get-action-name", 
    NULL,
    "/Methods/BseJanitor/General/Get Action Name",
    NULL,
    __enode_get_action_name__fill_strings,
  },
  0, get_action_name_setup, get_action_name_exec, 
};
static void
__enode_get_action_blurb__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the help string of an action of this janitor.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 187;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_get_action_blurb = {
  { (BseExportNode*) &__enode_get_action_name, BSE_EXPORT_NODE_PROC,
    "BseJanitor+get-action-blurb", 
    NULL,
    "/Methods/BseJanitor/General/Get Action Blurb",
    NULL,
    __enode_get_action_blurb__fill_strings,
  },
  0, get_action_blurb_setup, get_action_blurb_exec, 
};
static void
__enode_kill__fill_strings (BseExportStrings *es)
{
  es->blurb = "Kill a currently running janitor.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 217;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_kill = {
  { (BseExportNode*) &__enode_get_action_blurb, BSE_EXPORT_NODE_PROC,
    "BseJanitor+kill", 
    NULL,
    "/Methods/BseJanitor/General/Kill",
    NULL,
    __enode_kill__fill_strings,
  },
  0, kill_setup, kill_exec, 
};
static void
__enode_bse_script_janitor__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the connection dependant janitor object.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 239;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_bse_script_janitor = {
  { (BseExportNode*) &__enode_kill, BSE_EXPORT_NODE_PROC,
    "bse-script-janitor", 
    NULL,
    "/Proc/Script/Get Janitor",
    NULL,
    __enode_bse_script_janitor__fill_strings,
  },
  0, bse_script_janitor_setup, bse_script_janitor_exec, 
};
static void
__enode_bse_script_add_action__fill_strings (BseExportStrings *es)
{
  es->blurb = "Install a user action for script control.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 260;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_bse_script_add_action = {
  { (BseExportNode*) &__enode_bse_script_janitor, BSE_EXPORT_NODE_PROC,
    "bse-script-add-action", 
    NULL,
    "/Proc/Script/Add Action",
    NULL,
    __enode_bse_script_add_action__fill_strings,
  },
  0, bse_script_add_action_setup, bse_script_add_action_exec, 
};
static void
__enode_bse_script_remove_action__fill_strings (BseExportStrings *es)
{
  es->blurb = "Remove a previously installed user action from script control.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 293;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_bse_script_remove_action = {
  { (BseExportNode*) &__enode_bse_script_add_action, BSE_EXPORT_NODE_PROC,
    "bse-script-remove-action", 
    NULL,
    "/Proc/Script/Remove Action",
    NULL,
    __enode_bse_script_remove_action__fill_strings,
  },
  0, bse_script_remove_action_setup, bse_script_remove_action_exec, 
};
static void
__enode_bse_script_set_status__fill_strings (BseExportStrings *es)
{
  es->blurb = "Alter script status message.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 320;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_bse_script_set_status = {
  { (BseExportNode*) &__enode_bse_script_remove_action, BSE_EXPORT_NODE_PROC,
    "bse-script-set-status", 
    NULL,
    "/Proc/Script/Set Status",
    NULL,
    __enode_bse_script_set_status__fill_strings,
  },
  0, bse_script_set_status_setup, bse_script_set_status_exec, 
};
static void
__enode_bse_script_progress__fill_strings (BseExportStrings *es)
{
  es->blurb = "Indicate progress (from 0.0 to 1.0 or -1 for unknown amount).";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 348;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_bse_script_progress = {
  { (BseExportNode*) &__enode_bse_script_set_status, BSE_EXPORT_NODE_PROC,
    "bse-script-progress", 
    NULL,
    "/Proc/Script/Progress",
    NULL,
    __enode_bse_script_progress__fill_strings,
  },
  0, bse_script_progress_setup, bse_script_progress_exec, 
};
static void
__enode_bse_script_send_message__fill_strings (BseExportStrings *es)
{
  es->blurb = "Send a message from a script.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 375;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_bse_script_send_message = {
  { (BseExportNode*) &__enode_bse_script_progress, BSE_EXPORT_NODE_PROC,
    "bse-script-send-message", 
    NULL,
    "/Proc/Script/Message",
    NULL,
    __enode_bse_script_send_message__fill_strings,
  },
  0, bse_script_send_message_setup, bse_script_send_message_exec, 
};
static void
__enode_bse_script_quit__fill_strings (BseExportStrings *es)
{
  es->blurb = "Exit a script succesfully (server side).";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 414;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_bse_script_quit = {
  { (BseExportNode*) &__enode_bse_script_send_message, BSE_EXPORT_NODE_PROC,
    "bse-script-quit", 
    NULL,
    "/Proc/Script/Quit",
    NULL,
    __enode_bse_script_quit__fill_strings,
  },
  0, bse_script_quit_setup, bse_script_quit_exec, 
};
BseExportNode* bse__builtin_init_bsejanitor_genprc_c (void);
BseExportNode* bse__builtin_init_bsejanitor_genprc_c (void)
{
  return (BseExportNode*) &__enode_bse_script_quit;
}

/*
 * Generated data ends here
 */
