/* BSE - Bedevilled Sound Engine
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __BSE_SEQUENCER_H__
#define __BSE_SEQUENCER_H__

#include	<bse/bsebase.h>


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */


struct _BseSequencer
{
  BseLoopType	loop_type;
  
  guint next_pattern_row;
  guint first_pattern_row;
  guint last_pattern_row;
  
  /* pattern_list indices
   */
  guint	next_pattern;
  guint first_pattern;
  guint last_pattern;
  
  guint step_counter;
  guint step_threshold;
  
  /* trigger callback
   */
  BseSequencerTickCB	 tick_callback;
  gpointer		 tick_callback_data;
  BsePattern		*tick_pattern;
  guint			 tick_row;
};


void		bse_sequencer_start		(BseSong	*song,
						 BseSequencerTickCB callback,
						 gpointer	 callback_data);
void		bse_sequencer_recalc		(BseSong	*song);
void		bse_sequencer_set_loop		(BseSong	*song,
						 guint		 start_pattern_index,
						 guint		 end_pattern_index);
void		bse_sequencer_set_pattern_loop	(BseSong	*song,
						 guint		 start_pattern_row,
						 guint		 end_pattern_row);
void		bse_sequencer_step		(BseSong	*song,
						 guint		 n_voices,
						 BseVoice	*voices);
void		bse_sequencer_stop		(BseSong	*song);
void		bse_sequencer_trigger_tick	(BseSong	*song);




#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */

#endif /* __BSE_SEQUENCER_H__ */
