/* BEAST - Bedevilled Audio System
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#include	"bstmessagebox.h"
#include        <stdarg.h>

/* --- prototypes --- */
extern gchar*   g_vsprintf (const gchar *fmt, va_list *args1, va_list *args2);
static void     bst_message_box_init		(BstMessageBox	*mb);


/* --- functions --- */
GtkType
bst_message_box_get_type (void)
{
  static GtkType mb_type = 0;

  if (!mb_type)
    {
      GtkTypeInfo mb_info =
      {
	"BstMessageBox",
	sizeof (BstMessageBox),
	sizeof (BstMessageBoxClass),
	(GtkClassInitFunc) NULL,
	(GtkObjectInitFunc) bst_message_box_init,
	(GtkArgSetFunc) NULL,
	(GtkArgGetFunc) NULL,
      };

      mb_type = gtk_type_unique (gtk_window_get_type (), &mb_info);
    }

  return mb_type;
}

static void
bst_message_box_init (BstMessageBox  *mb)
{
  GtkWidget *main_vbox;
  GtkWidget *vbox;
  GtkWidget *any;
  GtkWidget *button;

  gtk_widget_set (GTK_WIDGET (mb),
		  "GtkWindow::type", GTK_WINDOW_TOPLEVEL,
		  "GtkWindow::title", "BEAST Message",
		  "GtkWindow::window_position", GTK_WIN_POS_MOUSE,
		  "GtkWindow::allow_shrink", FALSE,
		  "GtkWindow::allow_grow", FALSE,
		  "GtkWindow::auto_shrink", TRUE,
		  NULL);
  main_vbox =
    gtk_widget_new (gtk_vbox_get_type (),
		    "GtkBox::homogeneous", FALSE,
		    "GtkBox::spacing", 0,
		    "GtkContainer::border_width", 0,
		    "GtkWidget::parent", mb,
		    "GtkWidget::visible", TRUE,
		    NULL);
  vbox =
    gtk_widget_new (gtk_vbox_get_type (),
		    "GtkBox::homogeneous", FALSE,
		    "GtkBox::spacing", 0,
		    "GtkContainer::border_width", 5,
		    "GtkWidget::parent", main_vbox,
		    "GtkWidget::visible", TRUE,
		    NULL);
  mb->text_label =
    gtk_widget_new (gtk_label_get_type (),
		    "GtkLabel::label", "A Message",
		    "GtkWidget::parent", vbox,
		    "GtkWidget::visible", TRUE,
		    NULL);
  gtk_label_set_justify (GTK_LABEL (mb->text_label), GTK_JUSTIFY_LEFT);
  any =
    gtk_widget_new (gtk_hseparator_get_type (),
		    "GtkWidget::parent", main_vbox,
		    "GtkWidget::visible", TRUE,
		    NULL);
  vbox =
    gtk_widget_new (gtk_vbox_get_type (),
		    "GtkBox::homogeneous", FALSE,
		    "GtkBox::spacing", 0,
		    "GtkContainer::border_width", 5,
		    "GtkWidget::parent", main_vbox,
		    "GtkWidget::visible", TRUE,
		    NULL);
  button =
    gtk_widget_new (gtk_button_get_type (),
		    "GtkButton::label", "Close",
		    "GtkWidget::parent", vbox,
		    "GtkWidget::visible", TRUE,
		    "GtkWidget::can_default", TRUE,
		    "GtkWidget::has_default", TRUE,
		    "GtkObject::object_signal::clicked", gtk_widget_destroy, mb,
		    NULL);
}

GtkWidget*
bst_message_box_new (const gchar    *message)
{
  GtkWidget *widget;

  g_return_val_if_fail (message != NULL, NULL);

  widget = gtk_type_new (bst_message_box_get_type ());

  bst_message_box_set_text (BST_MESSAGE_BOX (widget),
			    message);

  return widget;
}

void
bst_message_box_set_text (BstMessageBox  *mb,
			  const gchar    *message)
{
  g_return_if_fail (mb != NULL);
  g_return_if_fail (BST_IS_MESSAGE_BOX (mb));
  g_return_if_fail (message != NULL);

  gtk_label_set (GTK_LABEL (mb->text_label), message);
}

void
bst_message_box_set_textf (BstMessageBox  *mb,
			   const gchar    *message_format,
			   ...)
{
  gchar *buffer;
  va_list    args1;
  va_list    args2;

  g_return_if_fail (mb != NULL);
  g_return_if_fail (BST_IS_MESSAGE_BOX (mb));
  g_return_if_fail (message_format != NULL);

  va_start (args1, message_format);
  va_start (args2, message_format);
  buffer = g_strdup (g_vsprintf (message_format, &args1, &args2));
  va_end (args1);
  va_end (args2);

  bst_message_box_set_text (mb, buffer);

  g_free (buffer);
}

GtkWidget*
bst_message_box_popup (GtkObject      *alive_object,
		       const gchar    *message_format,
		       ...)
{
  GtkWidget *mb;
  va_list    args1;
  va_list    args2;
  gchar *buffer;

  g_return_val_if_fail (message_format != NULL, NULL);

  va_start (args1, message_format);
  va_start (args2, message_format);
  buffer = g_strdup (g_vsprintf (message_format, &args1, &args2));
  va_end (args1);
  va_end (args2);

  mb = bst_message_box_new (buffer);

  g_free (buffer);
  
  if (alive_object)
    gtk_signal_connect_object_while_alive (GTK_OBJECT (alive_object),
					   "destroy",
					   GTK_SIGNAL_FUNC (gtk_widget_destroy),
					   GTK_OBJECT (mb));
  else
    gtk_quit_add_destroy (1, GTK_OBJECT (mb));

  gtk_widget_show (mb);

  return mb;
}
