/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.antclipse;

import java.io.File;
import net.sf.antcontrib.antclipse.ClassPathParser;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.RegexpPatternMapper;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ClassPathTask
extends Task {
    private String project;
    private String idContainer = "antclipse";
    private boolean includeSource = false;
    private boolean includeOutput = false;
    private boolean includeLibs = true;
    private boolean verbose = false;
    RegexpPatternMapper irpm = null;
    RegexpPatternMapper erpm = null;
    public static final String TARGET_CLASSPATH = "classpath";
    public static final String TARGET_FILESET = "fileset";
    private String produce = null;

    public void setIncludeLibs(boolean includeLibs) {
        this.includeLibs = includeLibs;
    }

    public void setproduce(String produce) {
        this.produce = produce;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setExcludes(String excludes) {
        if (excludes != null) {
            this.erpm = new RegexpPatternMapper();
            this.erpm.setFrom(excludes);
            this.erpm.setTo(".");
        } else {
            this.erpm = null;
        }
    }

    public void setIncludes(String includes) {
        if (includes != null) {
            this.irpm = new RegexpPatternMapper();
            this.irpm.setFrom(includes);
            this.irpm.setTo(".");
        } else {
            this.irpm = null;
        }
    }

    public void setIdContainer(String idContainer) {
        this.idContainer = idContainer;
    }

    public void setIncludeOutput(boolean includeOutput) {
        this.includeOutput = includeOutput;
    }

    public void setIncludeSource(boolean includeSource) {
        this.includeSource = includeSource;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public void execute() throws BuildException {
        AbstractCustomHandler handler;
        if (!TARGET_CLASSPATH.equalsIgnoreCase(this.produce) && !TARGET_FILESET.equals(this.produce)) {
            throw new BuildException("Mandatory target must be either 'classpath' or 'fileset'");
        }
        ClassPathParser parser = new ClassPathParser();
        if (TARGET_CLASSPATH.equalsIgnoreCase(this.produce)) {
            Path path = new Path(this.getProject());
            this.getProject().addReference(this.idContainer, (Object)path);
            handler = new PathCustomHandler(path);
        } else {
            FileSet fileSet = new FileSet();
            this.getProject().addReference(this.idContainer, (Object)fileSet);
            fileSet.setDir(new File(this.getProject().getBaseDir().getAbsolutePath().toString()));
            handler = new FileSetCustomHandler(fileSet);
        }
        parser.parse(new File(this.getProject().getBaseDir().getAbsolutePath(), ".classpath"), handler);
    }

    class PathCustomHandler
    extends AbstractCustomHandler {
        private Path path;

        public PathCustomHandler(Path path) {
            this.path = null;
            this.path = path;
        }

        private PathCustomHandler() {
            this.path = null;
        }

        public void startElement(String tag, AttributeList attrs) throws SAXParseException {
            if (tag.equalsIgnoreCase("classpathentry")) {
                Property property;
                String propName;
                String kind = attrs.getValue("kind");
                if (kind == null) {
                    throw new BuildException("classpathentry 'kind' attribute is mandatory");
                }
                String path = attrs.getValue("path");
                if (path == null) {
                    throw new BuildException("classpathentry 'path' attribute is mandatory");
                }
                if (kind.equalsIgnoreCase("output")) {
                    propName = ClassPathTask.this.idContainer + "outpath";
                    property = new Property();
                    property.setName(propName);
                    property.setValue(path);
                    property.setProject(ClassPathTask.this.getProject());
                    property.execute();
                    if (ClassPathTask.this.verbose) {
                        System.out.println("Setting property " + propName + " to value " + path);
                    }
                }
                if (kind.equalsIgnoreCase("src")) {
                    propName = ClassPathTask.this.idContainer + "srcpath";
                    property = new Property();
                    property.setName(propName);
                    property.setValue(path);
                    property.setProject(ClassPathTask.this.getProject());
                    property.execute();
                    if (ClassPathTask.this.verbose) {
                        System.out.println("Setting property " + propName + " to value " + path);
                    }
                }
                if (kind.equalsIgnoreCase("src") && ClassPathTask.this.includeSource || kind.equalsIgnoreCase("output") && ClassPathTask.this.includeOutput || kind.equalsIgnoreCase("lib") && ClassPathTask.this.includeLibs) {
                    String[] inclResult = new String[]{"all included"};
                    if (ClassPathTask.this.irpm != null) {
                        inclResult = ClassPathTask.this.irpm.mapFileName(path);
                    }
                    String[] exclResult = null;
                    if (ClassPathTask.this.erpm != null) {
                        exclResult = ClassPathTask.this.erpm.mapFileName(path);
                    }
                    if (inclResult != null && exclResult == null) {
                        if (ClassPathTask.this.verbose) {
                            System.out.println("Adding  " + path + " to classpath " + ClassPathTask.this.idContainer);
                        }
                        Path.PathElement element = this.path.createPathElement();
                        element.setLocation(new File(path));
                    }
                }
            }
        }
    }

    class FileSetCustomHandler
    extends AbstractCustomHandler {
        private FileSet fileSet;

        private FileSetCustomHandler() {
            this.fileSet = null;
        }

        public FileSetCustomHandler(FileSet fileSet) {
            this.fileSet = null;
            this.fileSet = fileSet;
            this.projDir = ClassPathTask.this.getProject().getBaseDir().getAbsolutePath().toString();
        }

        public void endDocument() throws SAXException {
            super.endDocument();
            if (this.fileSet != null && !this.fileSet.hasPatterns()) {
                this.fileSet.setExcludes("**/*");
            }
        }

        public void startElement(String tag, AttributeList attrs) throws SAXParseException {
            if (tag.equalsIgnoreCase("classpathentry")) {
                Property property;
                String propName;
                String kind = attrs.getValue("kind");
                if (kind == null) {
                    throw new BuildException("classpathentry 'kind' attribute is mandatory");
                }
                String path = attrs.getValue("path");
                if (path == null) {
                    throw new BuildException("classpathentry 'path' attribute is mandatory");
                }
                if (kind.equalsIgnoreCase("output")) {
                    propName = ClassPathTask.this.idContainer + "outpath";
                    property = new Property();
                    property.setName(propName);
                    property.setValue(path);
                    property.setProject(ClassPathTask.this.getProject());
                    property.execute();
                    if (ClassPathTask.this.verbose) {
                        System.out.println("Setting property " + propName + " to value " + path);
                    }
                }
                if (kind.equalsIgnoreCase("src")) {
                    propName = ClassPathTask.this.idContainer + "srcpath";
                    property = new Property();
                    property.setName(propName);
                    property.setValue(path);
                    property.setProject(ClassPathTask.this.getProject());
                    property.execute();
                    if (ClassPathTask.this.verbose) {
                        System.out.println("Setting property " + propName + " to value " + path);
                    }
                }
                if (kind.equalsIgnoreCase("src") && ClassPathTask.this.includeSource || kind.equalsIgnoreCase("output") && ClassPathTask.this.includeOutput || kind.equalsIgnoreCase("lib") && ClassPathTask.this.includeLibs) {
                    String[] inclResult = new String[]{"all included"};
                    if (ClassPathTask.this.irpm != null) {
                        inclResult = ClassPathTask.this.irpm.mapFileName(path);
                    }
                    String[] exclResult = null;
                    if (ClassPathTask.this.erpm != null) {
                        exclResult = ClassPathTask.this.erpm.mapFileName(path);
                    }
                    if (inclResult != null && exclResult == null) {
                        if (kind.equalsIgnoreCase("output")) {
                            FileSet outFileSet = new FileSet();
                            String newReference = ClassPathTask.this.idContainer + "-" + path.replace(File.separatorChar, '-');
                            ClassPathTask.this.getProject().addReference(newReference, (Object)outFileSet);
                            if (ClassPathTask.this.verbose) {
                                System.out.println("Created new fileset " + newReference + " containing all the files from the output dir " + this.projDir + File.separator + path);
                            }
                            outFileSet.setDefaultexcludes(false);
                            outFileSet.setDir(new File(this.projDir + File.separator + path));
                            outFileSet.setIncludes("**/*");
                        } else if (kind.equalsIgnoreCase("src")) {
                            FileSet srcFileSet = new FileSet();
                            String newReference = ClassPathTask.this.idContainer + "-" + path.replace(File.separatorChar, '-');
                            ClassPathTask.this.getProject().addReference(newReference, (Object)srcFileSet);
                            if (ClassPathTask.this.verbose) {
                                System.out.println("Created new fileset " + newReference + " containing all the files from the source dir " + this.projDir + File.separator + path);
                            }
                            srcFileSet.setDefaultexcludes(false);
                            srcFileSet.setDir(new File(this.projDir + File.separator + path));
                            srcFileSet.setIncludes("**/*");
                        } else {
                            File file = new File(this.fileSet.getDir(ClassPathTask.this.getProject()) + "/" + path);
                            if (file.isDirectory()) {
                                path = path + "/**/*";
                            }
                            if (ClassPathTask.this.verbose) {
                                System.out.println("Adding  " + path + " to fileset " + ClassPathTask.this.idContainer + " at " + this.fileSet.getDir(ClassPathTask.this.getProject()));
                            }
                            this.fileSet.setIncludes(path);
                        }
                    }
                }
            }
        }
    }

    abstract class AbstractCustomHandler
    extends HandlerBase {
        protected String projDir;
        protected static final String ATTRNAME_PATH = "path";
        protected static final String ATTRNAME_KIND = "kind";
        protected static final String ATTR_LIB = "lib";
        protected static final String ATTR_SRC = "src";
        protected static final String ATTR_OUTPUT = "output";
        protected static final String EMPTY = "";

        AbstractCustomHandler() {
        }
    }
}

