/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.File;
import java.math.BigDecimal;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.lib.Initializer;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.UntypedAtomicValue;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineOptions {
    public static final int TYPE_BOOLEAN = 1;
    public static final int TYPE_FILENAME = 2;
    public static final int TYPE_CLASSNAME = 3;
    public static final int TYPE_ENUMERATION = 4;
    public static final int TYPE_INTEGER = 5;
    public static final int TYPE_QNAME = 6;
    public static final int TYPE_FILENAME_LIST = 7;
    public static final int TYPE_DATETIME = 8;
    public static final int TYPE_STRING = 9;
    public static final int TYPE_INTEGER_PAIR = 10;
    public static final int VALUE_REQUIRED = 256;
    public static final int VALUE_PROHIBITED = 512;
    HashMap<String, Integer> recognizedOptions = new HashMap();
    HashMap<String, String> optionHelp = new HashMap();
    Properties namedOptions = new Properties();
    Properties configOptions = new Properties();
    Map<String, Set<String>> permittedValues = new HashMap<String, Set<String>>();
    Map<String, String> defaultValues = new HashMap<String, String>();
    List positionalOptions = new ArrayList();
    Properties paramValues = new Properties();
    Properties paramExpressions = new Properties();
    Properties paramFiles = new Properties();
    Properties serializationParams = new Properties();
    Initializer initializer;

    public void addRecognizedOption(String option, int optionProperties, String helpText) {
        this.recognizedOptions.put(option, optionProperties);
        this.optionHelp.put(option, helpText);
        if ((optionProperties & 0xFF) == 1) {
            this.setPermittedValues(option, new String[]{"on", "off"}, "on");
        }
    }

    public void setPermittedValues(String option, String[] values, String defaultValue) {
        HashSet<String> valueSet = new HashSet<String>();
        valueSet.addAll(Arrays.asList(values));
        this.permittedValues.put(option, valueSet);
        if (defaultValue != null) {
            this.defaultValues.put(option, defaultValue);
        }
    }

    private static String displayPermittedValues(Set<String> permittedValues) {
        FastStringBuffer sb = new FastStringBuffer(20);
        for (String val : permittedValues) {
            if ("".equals(val)) {
                sb.append("\"\"");
            } else {
                sb.append(val);
            }
            sb.append('|');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public void setActualOptions(String[] args) throws XPathException {
        for (int i = 0; i < args.length; ++i) {
            if ("-".equals(args[i])) {
                this.positionalOptions.add(args[1]);
                continue;
            }
            if (args[i].charAt(0) == '-') {
                String msg;
                int prop;
                String option;
                int colon;
                String value = "";
                if (args[i].length() > 5 && args[i].charAt(1) == '-') {
                    colon = args[i].lastIndexOf(58);
                    if (colon > 0 && colon < args[i].length() - 1) {
                        option = args[i].substring(2, colon);
                        value = args[i].substring(colon + 1);
                        this.configOptions.setProperty(option, value);
                        continue;
                    }
                    option = args[i].substring(2);
                    this.configOptions.setProperty(option, "true");
                    continue;
                }
                colon = args[i].indexOf(58);
                if (colon > 0 && colon < args[i].length() - 1) {
                    option = args[i].substring(1, colon);
                    value = args[i].substring(colon + 1);
                } else {
                    option = args[i].substring(1);
                }
                if (this.recognizedOptions.get(option) == null) {
                    throw new XPathException("Command line option -" + option + " is not recognized. Options available: " + this.displayPermittedOptions());
                }
                if (this.namedOptions.getProperty(option) != null) {
                    throw new XPathException("Command line option -" + option + " appears more than once");
                }
                if ("?".equals(value)) {
                    this.displayOptionHelp(option);
                    throw new XPathException("No processing requested");
                }
                if ("".equals(value)) {
                    prop = this.recognizedOptions.get(option);
                    if ((prop & 0x100) != 0) {
                        msg = "Command line option -" + option + " requires a value";
                        if (this.permittedValues.get(option) != null) {
                            msg = msg + ": permitted values are " + CommandLineOptions.displayPermittedValues(this.permittedValues.get(option));
                        }
                        throw new XPathException(msg);
                    }
                    String defaultValue = this.defaultValues.get(option);
                    if (defaultValue != null) {
                        value = defaultValue;
                    }
                } else {
                    prop = this.recognizedOptions.get(option);
                    if ((prop & 0x200) != 0) {
                        msg = "Command line option -" + option + " does not expect a value";
                        throw new XPathException(msg);
                    }
                }
                Set<String> permitted = this.permittedValues.get(option);
                if (permitted != null && !permitted.contains(value)) {
                    throw new XPathException("Bad option value " + args[i] + ": permitted values are " + CommandLineOptions.displayPermittedValues(permitted));
                }
                this.namedOptions.setProperty(option, value);
                continue;
            }
            int eq = args[i].indexOf(61);
            if (eq >= 1) {
                char ch;
                String keyword = args[i].substring(0, eq);
                String value = "";
                if (eq < args[i].length() - 1) {
                    value = args[i].substring(eq + 1);
                }
                if ((ch = args[i].charAt(0)) == '!' && eq >= 2) {
                    this.serializationParams.setProperty(keyword.substring(1), value);
                    continue;
                }
                if (ch == '?' && eq >= 2) {
                    this.paramExpressions.setProperty(keyword.substring(1), value);
                    continue;
                }
                if (ch == '+' && eq >= 2) {
                    this.paramFiles.setProperty(keyword.substring(1), value);
                    continue;
                }
                this.paramValues.setProperty(keyword, value);
                continue;
            }
            this.positionalOptions.add(args[i]);
        }
    }

    public boolean definesParameterValues() {
        return !this.serializationParams.isEmpty() || !this.paramExpressions.isEmpty() || !this.paramFiles.isEmpty() || !this.paramValues.isEmpty();
    }

    public boolean testIfSchemaAware() {
        return this.getOptionValue("sa") != null || this.getOptionValue("outval") != null || this.getOptionValue("val") != null || this.getOptionValue("vlax") != null || this.getOptionValue("xsd") != null || this.getOptionValue("xsdversion") != null;
    }

    public void applyToConfiguration(Configuration config) throws TransformerException {
        Object resolver;
        Enumeration<?> e = this.configOptions.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = this.configOptions.getProperty(name);
            try {
                config.setConfigurationProperty("http://saxon.sf.net/feature/" + name, value);
            }
            catch (IllegalArgumentException err) {
                throw new XPathException(err.getMessage());
            }
        }
        String value = this.getOptionValue("cr");
        if (value != null) {
            resolver = config.getInstance(value, null);
            config.setConfigurationProperty("http://saxon.sf.net/feature/collection-uri-resolver", resolver);
        }
        if ((value = this.getOptionValue("dtd")) != null) {
            if ("on".equals(value)) {
                config.getParseOptions().setDTDValidationMode(1);
            } else if ("off".equals(value)) {
                config.getParseOptions().setDTDValidationMode(4);
            } else if ("recover".equals(value)) {
                config.getParseOptions().setDTDValidationMode(2);
            }
        }
        if ((value = this.getOptionValue("expand")) != null) {
            config.getParseOptions().setExpandAttributeDefaults("on".equals(value));
        }
        if ((value = this.getOptionValue("ext")) != null) {
            config.setConfigurationProperty("http://saxon.sf.net/feature/allow-external-functions", "on".equals(value));
        }
        if ((value = this.getOptionValue("l")) != null) {
            config.setConfigurationProperty("http://saxon.sf.net/feature/linenumbering", "on".equals(value));
        }
        if ((value = this.getOptionValue("m")) != null) {
            config.setConfigurationProperty("http://saxon.sf.net/feature/messageEmitterClass", value);
        }
        if ((value = this.getOptionValue("opt")) != null) {
            config.setConfigurationProperty("http://saxon.sf.net/feature/optimizationLevel", value);
        }
        if ((value = this.getOptionValue("or")) != null) {
            resolver = config.getInstance(value, null);
            config.setConfigurationProperty("http://saxon.sf.net/feature/outputURIResolver", resolver);
        }
        if ((value = this.getOptionValue("outval")) != null) {
            Boolean isRecover = "recover".equals(value);
            config.setConfigurationProperty("http://saxon.sf.net/feature/validation-warnings", isRecover);
            config.setConfigurationProperty("http://saxon.sf.net/feature/validation-comments", isRecover);
        }
        if ((value = this.getOptionValue("r")) != null) {
            config.setURIResolver(config.makeURIResolver(value));
        }
        if ((value = this.getOptionValue("strip")) != null) {
            config.setConfigurationProperty("http://saxon.sf.net/feature/strip-whitespace", value);
        }
        if ((value = this.getOptionValue("TJ")) != null) {
            config.setConfigurationProperty("http://saxon.sf.net/feature/trace-external-functions", "on".equals(value));
        }
        if ((value = this.getOptionValue("tree")) != null) {
            if ("linked".equals(value)) {
                config.setTreeModel(0);
            } else if ("tiny".equals(value)) {
                config.setTreeModel(1);
            } else if ("tinyc".equals(value)) {
                config.setTreeModel(2);
            }
        }
        if ((value = this.getOptionValue("val")) != null) {
            if ("strict".equals(value)) {
                config.setConfigurationProperty("http://saxon.sf.net/feature/schema-validation", 1);
            } else if ("lax".equals(value)) {
                config.setConfigurationProperty("http://saxon.sf.net/feature/schema-validation", 2);
            }
        }
        if ((value = this.getOptionValue("versionmsg")) != null) {
            config.setConfigurationProperty("http://saxon.sf.net/feature/version-warning", "on".equals(value));
        }
        if ((value = this.getOptionValue("warnings")) != null) {
            if ("silent".equals(value)) {
                config.setConfigurationProperty("http://saxon.sf.net/feature/recoveryPolicy", 0);
            } else if ("recover".equals(value)) {
                config.setConfigurationProperty("http://saxon.sf.net/feature/recoveryPolicy", 1);
            } else if ("fatal".equals(value)) {
                config.setConfigurationProperty("http://saxon.sf.net/feature/recoveryPolicy", 2);
            }
        }
        if ((value = this.getOptionValue("x")) != null) {
            config.setConfigurationProperty("http://saxon.sf.net/feature/sourceParserClass", value);
        }
        if ((value = this.getOptionValue("xi")) != null) {
            config.setConfigurationProperty("http://saxon.sf.net/feature/xinclude-aware", "on".equals(value));
        }
        if ((value = this.getOptionValue("xmlversion")) != null) {
            config.setConfigurationProperty("http://saxon.sf.net/feature/xml-version", value);
        }
        if ((value = this.getOptionValue("xsdversion")) != null) {
            config.setConfigurationProperty("http://saxon.sf.net/feature/xsd-version", value);
        }
        if ((value = this.getOptionValue("xsiloc")) != null) {
            config.setConfigurationProperty("http://saxon.sf.net/feature/useXsiSchemaLocation", "on".equals(value));
        }
        if ((value = this.getOptionValue("xsltversion")) != null) {
            config.setConfigurationProperty("http://saxon.sf.net/feature/xsltVersion", value);
        }
        if ((value = this.getOptionValue("y")) != null) {
            config.setConfigurationProperty("http://saxon.sf.net/feature/sourceParserClass", value);
        }
        if ((value = this.getOptionValue("init")) != null) {
            Initializer initializer = (Initializer)config.getInstance(value, null);
            initializer.initialize(config);
        }
    }

    public String displayPermittedOptions() {
        String[] options = new String[this.recognizedOptions.size()];
        options = new ArrayList<String>(this.recognizedOptions.keySet()).toArray(options);
        Arrays.sort(options, Collator.getInstance());
        FastStringBuffer sb = new FastStringBuffer(100);
        for (String opt : options) {
            sb.append(" -");
            sb.append(opt);
        }
        return sb.toString();
    }

    private void displayOptionHelp(String option) {
        System.err.println("Help for -" + option + " option");
        int prop = this.recognizedOptions.get(option);
        if ((prop & 0x200) == 0) {
            switch (prop & 0xFF) {
                case 1: {
                    System.err.println("Value: on|off");
                    break;
                }
                case 5: {
                    System.err.println("Value: integer");
                    break;
                }
                case 2: {
                    System.err.println("Value: file name");
                    break;
                }
                case 7: {
                    System.err.println("Value: list of file names, semicolon-separated");
                    break;
                }
                case 3: {
                    System.err.println("Value: Java fully-qualified class name");
                    break;
                }
                case 6: {
                    System.err.println("Value: QName in Clark notation ({uri}local)");
                    break;
                }
                case 9: {
                    System.err.println("Value: string");
                    break;
                }
                case 10: {
                    System.err.println("Value: int,int");
                    break;
                }
                case 4: {
                    String message = "Value: one of ";
                    message = message + CommandLineOptions.displayPermittedValues(this.permittedValues.get(option));
                    System.err.println(message);
                    break;
                }
            }
        }
        System.err.println("Meaning: " + this.optionHelp.get(option));
    }

    public String getOptionValue(String option) {
        return this.namedOptions.getProperty(option);
    }

    public List<String> getPositionalOptions() {
        return this.positionalOptions;
    }

    public void setParams(Configuration config, Controller controller, DynamicQueryContext qcontext, Properties outputProperties) throws TransformerException {
        String value;
        String name;
        boolean useURLs = "on".equals(this.getOptionValue("u"));
        Enumeration<?> e = this.paramValues.propertyNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            value = this.paramValues.getProperty(name);
            if (controller != null) {
                controller.setParameter(name, (Object)new UntypedAtomicValue(value));
            }
            if (qcontext == null) continue;
            qcontext.setParameterValue(name, new UntypedAtomicValue(value));
        }
        e = this.paramFiles.propertyNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            value = this.paramFiles.getProperty(name);
            Object sources = CommandLineOptions.loadDocuments(value, useURLs, config, true);
            if (controller != null) {
                controller.setParameter(name, sources);
            }
            if (qcontext == null) continue;
            qcontext.setParameter(name, sources);
        }
        e = this.paramExpressions.propertyNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            value = this.paramExpressions.getProperty(name);
            XPathEvaluator xpe = new XPathEvaluator(config);
            XPathExpression expr = xpe.createExpression(value);
            XPathDynamicContext context = expr.createDynamicContext();
            ValueRepresentation val = SequenceExtent.makeSequenceExtent(expr.iterate(context));
            if (controller != null) {
                controller.setParameter(name, (Object)val);
            }
            if (qcontext == null) continue;
            qcontext.setParameterValue(name, val);
        }
        e = this.serializationParams.propertyNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            value = this.serializationParams.getProperty(name);
            if (name.startsWith("!saxon:")) {
                name = "{http://saxon.sf.net/}" + name.substring(7);
            }
            if (controller != null) {
                controller.setOutputProperty(name, value);
            }
            if (outputProperties == null) continue;
            outputProperties.setProperty(name, value);
        }
    }

    public static Object loadDocuments(String sourceFileName, boolean useURLs, Configuration config, boolean useSAXSource) throws TransformerException {
        Source sourceInput;
        if (useURLs || sourceFileName.startsWith("http:") || sourceFileName.startsWith("file:")) {
            Source sourceInput2 = config.getURIResolver().resolve(sourceFileName, null);
            if (sourceInput2 == null) {
                sourceInput2 = config.getSystemURIResolver().resolve(sourceFileName, null);
            }
            return sourceInput2;
        }
        if (sourceFileName.equals("-")) {
            Source sourceInput3;
            if (useSAXSource) {
                XMLReader parser = config.getSourceParser();
                sourceInput3 = new SAXSource(parser, new InputSource(System.in));
            } else {
                sourceInput3 = new StreamSource(System.in);
            }
            return sourceInput3;
        }
        File sourceFile = new File(sourceFileName);
        if (!sourceFile.exists()) {
            throw new TransformerException("Source file " + sourceFile + " does not exist");
        }
        if (sourceFile.isDirectory()) {
            XMLReader parser = config.getSourceParser();
            ArrayList<StreamSource> result = new ArrayList<StreamSource>(20);
            String[] files = sourceFile.list();
            for (int f = 0; f < files.length; ++f) {
                Source sourceInput4;
                File file = new File(sourceFile, files[f]);
                if (file.isDirectory()) continue;
                if (useSAXSource) {
                    InputSource eis = new InputSource(file.toURI().toString());
                    sourceInput4 = new SAXSource(parser, eis);
                } else {
                    sourceInput4 = new StreamSource(file.toURI().toString());
                }
                result.add((StreamSource)sourceInput4);
            }
            return result;
        }
        if (useSAXSource) {
            InputSource eis = new InputSource(sourceFile.toURI().toString());
            sourceInput = new SAXSource(config.getSourceParser(), eis);
        } else {
            sourceInput = new StreamSource(sourceFile.toURI().toString());
        }
        return sourceInput;
    }

    public static void loadAdditionalSchemas(Configuration config, String additionalSchemas) throws TransformerException {
        StringTokenizer st = new StringTokenizer(additionalSchemas, ";");
        while (st.hasMoreTokens()) {
            String schema = st.nextToken();
            File schemaFile = new File(schema);
            if (!schemaFile.exists()) {
                throw new TransformerException("Schema document " + schema + " not found");
            }
            config.addSchemaSource(new StreamSource(schemaFile));
        }
    }

    public static String showExecutionTime(long millisecs) {
        if (millisecs < 1000L) {
            return millisecs + "ms";
        }
        try {
            DayTimeDurationValue d = new DayTimeDurationValue(1, 0, 0, 0, millisecs / 1000L, (int)millisecs % 1000 * 1000);
            long days = ((NumericValue)d.getComponent(3)).longValue();
            long hours = ((NumericValue)d.getComponent(4)).longValue();
            long minutes = ((NumericValue)d.getComponent(5)).longValue();
            BigDecimal seconds = ((NumericValue)d.getComponent(6)).getDecimalValue();
            FastStringBuffer fsb = new FastStringBuffer(256);
            if (days > 0L) {
                fsb.append(days + "days ");
            }
            if (hours > 0L) {
                fsb.append(hours + "h ");
            }
            if (minutes > 0L) {
                fsb.append(minutes + "m ");
            }
            fsb.append(seconds + "s");
            return fsb.toString() + " (" + millisecs + "ms)";
        }
        catch (XPathException e) {
            return millisecs + "ms";
        }
    }
}

