/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.runtime.XLibrary;
import com.xmlcalabash.util.JSONtoXML;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.URIUtils;
import java.io.File;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

public class ParseArgs {
    public boolean debugExplicit = false;
    public boolean debug = false;
    public boolean showVersion = false;
    public String saxonProcessor = null;
    public String saxonConfigFile = null;
    public boolean schemaAwareExplicit = false;
    public boolean schemaAware = false;
    public boolean safeModeExplicit = false;
    public boolean safeMode = false;
    public String configFile = null;
    public String logStyle = null;
    public String entityResolverClass = null;
    public String uriResolverClass = null;
    private QName stepName = null;
    public String pipelineURI = null;
    private Vector<String> libraries = new Vector();
    public Hashtable<String, String> outputs = new Hashtable();
    private Hashtable<String, String> bindings = new Hashtable();
    private Vector<StepArgs> steps = new Vector();
    private StepArgs curStep = new StepArgs();
    private StepArgs lastStep = null;
    public boolean extensionValues = false;
    public boolean allowXPointerOnText = false;
    public boolean transparentJSON = false;
    public String jsonFlavor = null;
    public boolean useXslt10 = false;
    private String[] args = null;
    private int argpos = 0;
    private String arg = null;

    public void parse(String[] args) {
        this.args = args;
        this.argpos = 0;
        this.bindings.put("p", "http://www.w3.org/ns/xproc");
        while (this.arg != null || this.argpos < args.length) {
            if (this.arg == null) {
                this.arg = args[this.argpos];
            }
            if (this.arg.startsWith("-P") || this.arg.startsWith("--saxon-processor")) {
                this.saxonProcessor = this.parseString("P", "saxon-processor");
                if ("he".equals(this.saxonProcessor) || "pe".equals(this.saxonProcessor) || "ee".equals(this.saxonProcessor)) continue;
                throw new XProcException("Invalid Saxon processor option: " + this.saxonProcessor + ". Must be 'he', 'pe', or 'ee'.");
            }
            if (this.arg.startsWith("--saxon-configuration")) {
                this.saxonConfigFile = this.parseString(null, "saxon-configuration");
                continue;
            }
            if (this.arg.startsWith("-a") || this.arg.startsWith("--schema-aware")) {
                this.schemaAware = this.parseBoolean("a", "schema-aware");
                this.schemaAwareExplicit = true;
                continue;
            }
            if (this.arg.startsWith("-D") || this.arg.startsWith("--debug")) {
                this.debug = this.parseBoolean("D", "debug");
                this.debugExplicit = true;
                continue;
            }
            if (this.arg.startsWith("-S") || this.arg.startsWith("--safe-mode")) {
                this.safeMode = this.parseBoolean("S", "safe-mode");
                this.safeModeExplicit = true;
                continue;
            }
            if (this.arg.startsWith("-c") || this.arg.startsWith("--config")) {
                this.configFile = this.parseString("c", "config");
                continue;
            }
            if (this.arg.startsWith("-G") || this.arg.startsWith("--log-style")) {
                this.logStyle = this.parseString("G", "log-style");
                if ("off".equals(this.logStyle) || "plain".equals(this.logStyle) || "wrapped".equals(this.logStyle) || "directory".equals(this.logStyle)) continue;
                throw new XProcException("Invalid log style: " + this.logStyle);
            }
            if (this.arg.startsWith("-E") || this.arg.startsWith("--entity-resolver")) {
                this.entityResolverClass = this.parseString("E", "entity-resolver");
                continue;
            }
            if (this.arg.startsWith("-U") || this.arg.startsWith("--uri-resolver")) {
                this.uriResolverClass = this.parseString("U", "uri-resolver");
                continue;
            }
            if (this.arg.startsWith("-i") || this.arg.equals("--input")) {
                this.parseInput("i", "input");
                continue;
            }
            if (this.arg.startsWith("-d") || this.arg.equals("--data-input")) {
                this.parseDataInput("d", "data-input");
                continue;
            }
            if (this.arg.startsWith("-o") || this.arg.equals("--output")) {
                this.parseOutput("o", "output");
                continue;
            }
            if (this.arg.startsWith("-b") || this.arg.equals("--binding")) {
                this.parseBinding("b", "binding");
                continue;
            }
            if (this.arg.startsWith("-p") || this.arg.equals("--with-param")) {
                this.parseParam("p", "with-param");
                continue;
            }
            if (this.arg.startsWith("-v") || this.arg.equals("--version")) {
                this.showVersion = this.parseBoolean("v", "version");
                continue;
            }
            if (this.arg.startsWith("-s") || this.arg.startsWith("--step")) {
                this.stepName = this.parseQName("s", "step");
                this.curStep.setName(this.stepName);
                this.steps.add(this.curStep);
                this.lastStep = this.curStep;
                this.curStep = new StepArgs();
                continue;
            }
            if (this.arg.startsWith("-l") || this.arg.startsWith("--library")) {
                String libraryURI = this.parseString("l", "library");
                this.libraries.add(libraryURI);
                continue;
            }
            if (this.arg.startsWith("-X") || this.arg.startsWith("--extension")) {
                String ext = this.parseString("X", "extension");
                if ("general-values".equals(ext)) {
                    this.extensionValues = true;
                    continue;
                }
                if ("xpointer-on-text".equals(ext)) {
                    this.allowXPointerOnText = true;
                    continue;
                }
                if ("use-xslt-1.0".equals(ext) || "use-xslt-10".equals(ext)) {
                    this.useXslt10 = true;
                    continue;
                }
                if ("transparent-json".equals(ext)) {
                    this.transparentJSON = true;
                    continue;
                }
                if (ext.startsWith("json-flavor=")) {
                    this.jsonFlavor = ext.substring(12);
                    if (JSONtoXML.knownFlavor(this.jsonFlavor)) continue;
                    throw new XProcException("Can't parse JSON flavor '" + ext + "' or unrecognized format: " + this.jsonFlavor);
                }
                throw new XProcException("Unexpected extension: " + ext);
            }
            if (this.arg.startsWith("-")) {
                throw new XProcException("Unrecognized option: " + this.arg);
            }
            if (!this.arg.contains("=")) break;
            this.parseOption(this.arg);
            this.arg = null;
            ++this.argpos;
        }
        if (this.stepName != null && this.argpos < args.length && !args[this.argpos].contains("=")) {
            throw new XProcException("Bad command line. You can specify a step or a pipeline, not both.");
        }
        if (this.libraries.size() == 0 && this.stepName == null && this.argpos < args.length) {
            this.pipelineURI = args[this.argpos++];
        }
        while (this.argpos < args.length) {
            if (args[this.argpos].startsWith("-")) {
                throw new XProcException("Only options can occur on the command line after the pipeline document.");
            }
            this.parseOption(args[this.argpos++]);
        }
    }

    public Set<String> getInputPorts() {
        if (this.steps.size() != 0) {
            return new HashSet<String>();
        }
        return this.curStep.inputs.keySet();
    }

    public Vector<String> getInputs(String port) {
        if (this.steps.size() != 0) {
            return new Vector<String>();
        }
        return this.curStep.inputs.get(port);
    }

    public Set<QName> getOptionNames() {
        if (this.steps.size() != 0) {
            return new HashSet<QName>();
        }
        return this.curStep.options.keySet();
    }

    public String getOption(QName name) {
        if (this.steps.size() != 0) {
            return null;
        }
        return this.curStep.options.get(name);
    }

    public Set<String> getParameterPorts() {
        if (this.steps.size() != 0) {
            return new HashSet<String>();
        }
        return this.curStep.params.keySet();
    }

    public Set<QName> getParameterNames(String port) {
        if (this.steps.size() != 0) {
            return new HashSet<QName>();
        }
        return this.curStep.params.get(port).keySet();
    }

    public String getParameter(String port, QName name) {
        if (this.steps.size() != 0) {
            return null;
        }
        return this.curStep.params.get(port).get(name);
    }

    public boolean impliedPipeline() {
        return this.steps.size() > 0 || this.libraries.size() > 0;
    }

    public XdmNode implicitPipeline(XProcRuntime runtime) {
        if (this.steps.size() == 0 && this.libraries.size() == 1) {
            try {
                XLibrary library = runtime.loadLibrary(this.libraries.get(0));
                this.curStep.setName(library.getFirstPipelineType());
                this.steps.add(this.curStep);
            }
            catch (SaxonApiException sae) {
                throw new XProcException(sae);
            }
        }
        TreeWriter tree = new TreeWriter(runtime);
        tree.startDocument(runtime.getStaticBaseURI());
        tree.addStartElement(XProcConstants.p_declare_step);
        tree.addAttribute(new QName("version"), "1.0");
        tree.startContent();
        tree.addStartElement(XProcConstants.p_input);
        tree.addAttribute(new QName("port"), "source");
        tree.addAttribute(new QName("sequence"), "true");
        tree.startContent();
        tree.addEndElement();
        tree.addStartElement(XProcConstants.p_input);
        tree.addAttribute(new QName("port"), "parameters");
        tree.addAttribute(new QName("kind"), "parameter");
        tree.startContent();
        tree.addEndElement();
        if (this.outputs.size() == 0) {
            this.outputs.put("result", "-");
        }
        String lastStepName = "cmdlineStep" + this.steps.size();
        for (String port : this.outputs.keySet()) {
            tree.addStartElement(XProcConstants.p_output);
            tree.addAttribute(new QName("port"), port);
            tree.startContent();
            tree.addStartElement(XProcConstants.p_pipe);
            tree.addAttribute(new QName("step"), lastStepName);
            tree.addAttribute(new QName("port"), port);
            tree.startContent();
            tree.addEndElement();
            tree.addEndElement();
        }
        for (String library : this.libraries) {
            tree.addStartElement(XProcConstants.p_import);
            tree.addAttribute(new QName("href"), library);
            tree.startContent();
            tree.addEndElement();
        }
        int stepNum = 0;
        for (StepArgs step : this.steps) {
            tree.addStartElement(step.stepName);
            tree.addAttribute(new QName("name"), "cmdlineStep" + ++stepNum);
            for (QName optname : step.options.keySet()) {
                tree.addAttribute(optname, step.options.get(optname));
            }
            tree.startContent();
            for (String port : step.inputs.keySet()) {
                tree.addStartElement(XProcConstants.p_input);
                tree.addAttribute(new QName("port"), port);
                tree.startContent();
                for (String uri : step.inputs.get(port)) {
                    QName qname = XProcConstants.p_document;
                    if (uri.startsWith("xml:")) {
                        uri = uri.substring(4);
                    } else if (uri.startsWith("data:")) {
                        qname = XProcConstants.p_data;
                        uri = uri.substring(5);
                    } else {
                        throw new UnsupportedOperationException("Unexpected URI type: " + uri);
                    }
                    if ("p:empty".equals(uri)) {
                        tree.addStartElement(XProcConstants.p_empty);
                        tree.startContent();
                        tree.addEndElement();
                        continue;
                    }
                    tree.addStartElement(qname);
                    tree.addAttribute(new QName("href"), uri);
                    tree.startContent();
                    tree.addEndElement();
                }
                tree.addEndElement();
            }
            for (String port : step.params.keySet()) {
                for (QName pname : step.params.get(port).keySet()) {
                    String value = step.params.get(port).get(pname);
                    if (value.contains("'") && value.contains("\"")) {
                        throw new IllegalArgumentException("I haven't figured out how to handle parameter values with both double and single quotes.");
                    }
                    value = value.contains("'") ? "\"" + value + "\"" : "'" + value + "'";
                    tree.addStartElement(XProcConstants.p_with_param);
                    if (!"*".equals(port)) {
                        tree.addAttribute(new QName("port"), port);
                    }
                    tree.addAttribute(new QName("name"), pname.toString());
                    tree.addAttribute(new QName("select"), value);
                    tree.startContent();
                    tree.addEndElement();
                }
            }
            tree.addEndElement();
            tree.endDocument();
        }
        tree.addEndElement();
        tree.endDocument();
        return tree.getResult();
    }

    private boolean parseBoolean(String shortName, String longName) {
        String sOpt = "-" + shortName;
        String lOpt = "--" + longName;
        boolean bool = false;
        if (this.arg.startsWith(sOpt)) {
            bool = true;
            if (this.arg.equals(sOpt)) {
                this.arg = null;
                ++this.argpos;
            } else {
                this.arg = "-" + this.arg.substring(2);
            }
            return bool;
        }
        if (this.arg.equals(lOpt)) {
            bool = true;
            this.arg = null;
            ++this.argpos;
            return bool;
        }
        if (this.arg.startsWith(lOpt + "=")) {
            this.arg = this.arg.substring(lOpt.length() + 1);
            if (!this.arg.equals("true") && !this.arg.equals("false")) {
                throw new XProcException("Unparseable command line argument: " + lOpt + "=" + this.arg);
            }
            bool = this.arg.equals("true");
            this.arg = null;
            ++this.argpos;
            return bool;
        }
        throw new XProcException("Unparseable command line argument: " + this.arg);
    }

    private String parseString(String shortName, String longName) {
        String sOpt;
        String value = null;
        if (shortName != null && this.arg.startsWith(sOpt = "-" + shortName)) {
            if (this.arg.equals(sOpt)) {
                value = this.args[++this.argpos];
                this.arg = null;
                ++this.argpos;
            } else {
                value = this.arg.substring(2);
                this.arg = null;
                ++this.argpos;
            }
            return value;
        }
        String lOpt = "--" + longName;
        if (this.arg.equals(lOpt)) {
            value = this.args[++this.argpos];
            this.arg = null;
            ++this.argpos;
            return value;
        }
        if (this.arg.startsWith(lOpt + "=")) {
            value = this.arg.substring(lOpt.length() + 1);
            this.arg = null;
            ++this.argpos;
            return value;
        }
        throw new XProcException("Unparseable command line argument: " + this.arg);
    }

    private QName parseQName(String shortName, String longName) {
        String sOpt = "-" + shortName;
        String lOpt = "--" + longName;
        String value = null;
        if (this.arg.startsWith(sOpt)) {
            if (this.arg.equals(sOpt)) {
                value = this.args[++this.argpos];
                this.arg = null;
                ++this.argpos;
            } else {
                value = this.arg.substring(2);
                this.arg = null;
                ++this.argpos;
            }
        } else if (this.arg.equals(lOpt)) {
            value = this.args[++this.argpos];
            this.arg = null;
            ++this.argpos;
        } else if (this.arg.startsWith(lOpt + "=")) {
            value = this.arg.substring(lOpt.length() + 1);
            this.arg = null;
            ++this.argpos;
        } else {
            throw new XProcException("Unparseable command line argument: " + this.arg);
        }
        QName qname = null;
        int cpos = value.indexOf(":");
        if (cpos > 0) {
            String prefix = value.substring(0, cpos);
            if (!this.bindings.containsKey(prefix)) {
                throw new XProcException("Unbound prefix \"" + prefix + "\": " + value);
            }
            String uri = this.bindings.get(prefix);
            qname = new QName(prefix, uri, value.substring(cpos + 1));
        } else {
            qname = new QName("", value);
        }
        return qname;
    }

    private KeyValuePair parseKeyValue(String shortName, String longName) {
        String sOpt = "-" + (shortName == null ? "" : shortName);
        String lOpt = "--" + longName;
        String opt = null;
        String oarg = this.arg;
        if (shortName != null && this.arg.startsWith(sOpt)) {
            if (this.arg.equals(sOpt)) {
                opt = this.args[++this.argpos];
                this.arg = null;
                ++this.argpos;
            } else {
                opt = this.arg.substring(2);
                this.arg = null;
                ++this.argpos;
            }
        } else if (this.arg.equals(lOpt)) {
            opt = this.args[++this.argpos];
            this.arg = null;
            ++this.argpos;
        } else {
            throw new XProcException("Unparseable command line argument: " + this.arg);
        }
        String key = null;
        String value = null;
        int eqpos = opt.indexOf("=");
        if (eqpos > 0) {
            key = opt.substring(0, eqpos);
            value = opt.substring(eqpos + 1);
        } else {
            key = opt;
            value = null;
        }
        if (value == null) {
            throw new XProcException("Unparseable command line argument: " + oarg);
        }
        return new KeyValuePair(key, value);
    }

    private void parseInput(String shortName, String longName) {
        KeyValuePair v = this.parseKeyValue(shortName, longName);
        String uri = v.value;
        if ("-".equals(uri) || uri.startsWith("http:") || uri.startsWith("https:") || uri.startsWith("file:") || "p:empty".equals(uri)) {
            this.curStep.addInput(v.key, uri, "xml");
        } else {
            File f = new File(uri);
            String fn = URIUtils.encode(f.getAbsolutePath());
            if ("\\".equals(System.getProperty("file.separator"))) {
                fn = "/" + fn;
            }
            this.curStep.addInput(v.key, "file://" + fn, "xml");
        }
    }

    private void parseDataInput(String shortName, String longName) {
        KeyValuePair v = this.parseKeyValue(shortName, longName);
        String uri = v.value;
        if ("-".equals(uri) || uri.startsWith("http:") || uri.startsWith("https:") || uri.startsWith("file:") || "p:empty".equals(uri)) {
            this.curStep.addInput(v.key, uri, "data");
        } else {
            File f = new File(uri);
            String fn = URIUtils.encode(f.getAbsolutePath());
            if ("\\".equals(System.getProperty("file.separator"))) {
                fn = "/" + fn;
            }
            this.curStep.addInput(v.key, "file://" + fn, "data");
        }
    }

    private void parseOutput(String shortName, String longName) {
        KeyValuePair v = this.parseKeyValue(shortName, longName);
        if (this.outputs.containsKey(v.key)) {
            throw new XProcException("Duplicate output binding: " + v.key);
        }
        String uri = v.value;
        if ("-".equals(uri)) {
            this.outputs.put(v.key, uri);
        } else {
            File f = new File(uri);
            String fn = URIUtils.encode(f.getAbsolutePath());
            if ("\\".equals(System.getProperty("file.separator"))) {
                fn = "/" + fn;
            }
            this.outputs.put(v.key, "file://" + fn);
        }
    }

    private void parseBinding(String shortName, String longName) {
        KeyValuePair v = this.parseKeyValue(shortName, longName);
        this.bindings.put(v.key, v.value);
    }

    private void parseParam(String shortName, String longName) {
        KeyValuePair v = this.parseKeyValue(shortName, longName);
        String port = "*";
        String name = v.key;
        String uri = null;
        QName qname = null;
        int cpos = name.indexOf("@");
        if (cpos > 0) {
            port = name.substring(0, cpos);
            name = name.substring(cpos + 1);
        }
        if ((cpos = name.indexOf(":")) > 0) {
            String prefix = name.substring(0, cpos);
            if (!this.bindings.containsKey(prefix)) {
                throw new XProcException("Unbound prefix \"" + prefix + "\": " + v.key + "=" + v.value);
            }
            uri = this.bindings.get(prefix);
            qname = new QName(prefix, uri, name.substring(cpos + 1));
        } else {
            qname = new QName("", name);
        }
        this.curStep.addParameter(port, qname, v.value);
    }

    private void parseOption(String opt) {
        String key = null;
        String value = null;
        int eqpos = opt.indexOf("=");
        if (eqpos > 0) {
            key = opt.substring(0, eqpos);
            value = opt.substring(eqpos + 1);
        } else {
            key = opt;
            value = null;
        }
        if (value == null) {
            throw new XProcException("Unparseable option: " + opt);
        }
        String uri = null;
        QName qname = null;
        int cpos = key.indexOf(":");
        if (cpos > 0) {
            String prefix = key.substring(0, cpos);
            if (!this.bindings.containsKey(prefix)) {
                throw new XProcException("Unbound prefix \"" + prefix + "\": " + key + "=" + value);
            }
            uri = this.bindings.get(prefix);
            qname = new QName(uri, key.substring(cpos + 1), prefix);
        } else {
            qname = new QName("", key);
        }
        if (this.lastStep != null) {
            this.lastStep.addOption(qname, value);
        } else {
            this.curStep.addOption(qname, value);
        }
    }

    private class StepArgs {
        public QName stepName = null;
        public Hashtable<String, Vector<String>> inputs = new Hashtable();
        public Hashtable<String, Hashtable<QName, String>> params = new Hashtable();
        public Hashtable<QName, String> options = new Hashtable();

        public void setName(QName name) {
            this.stepName = name;
        }

        public void addInput(String port, String uri, String type) {
            if (!this.inputs.containsKey(port)) {
                this.inputs.put(port, new Vector());
            }
            this.inputs.get(port).add(type + ":" + uri);
        }

        public void addOption(QName optname, String value) {
            if (this.options.containsKey(optname)) {
                throw new XProcException("Duplicate option name: " + optname);
            }
            this.options.put(optname, value);
        }

        public void addParameter(String port, QName name, String value) {
            Hashtable<Object, Object> portParams = !this.params.containsKey(port) ? new Hashtable() : this.params.get(port);
            if (portParams.containsKey(name)) {
                throw new XProcException("Duplicate parameter name: " + name);
            }
            portParams.put(name, value);
            this.params.put(port, portParams);
        }
    }

    private class KeyValuePair {
        public String key = null;
        public String value = null;

        public KeyValuePair(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

