
#ifndef KDEPIM_EXPORT_H
#define KDEPIM_EXPORT_H

#ifdef KDEPIM_STATIC_DEFINE
#  define KDEPIM_EXPORT
#  define KDEPIM_NO_EXPORT
#else
#  ifndef KDEPIM_EXPORT
#    ifdef KPim6Libkdepim_EXPORTS
        /* We are building this library */
#      define KDEPIM_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KDEPIM_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KDEPIM_NO_EXPORT
#    define KDEPIM_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KDEPIM_DECL_DEPRECATED
#  define KDEPIM_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KDEPIM_DECL_DEPRECATED_EXPORT
#  define KDEPIM_DECL_DEPRECATED_EXPORT KDEPIM_EXPORT KDEPIM_DECL_DEPRECATED
#endif

#ifndef KDEPIM_DECL_DEPRECATED_NO_EXPORT
#  define KDEPIM_DECL_DEPRECATED_NO_EXPORT KDEPIM_NO_EXPORT KDEPIM_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KDEPIM_NO_DEPRECATED
#    define KDEPIM_NO_DEPRECATED
#  endif
#endif
#include "libkdepim_version.h"

#define KDEPIM_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#if defined(KDEPIM_NO_DEPRECATED)
#  undef KDEPIM_DEPRECATED
#  define KDEPIM_DEPRECATED_EXPORT KDEPIM_EXPORT
#  define KDEPIM_DEPRECATED_NO_EXPORT KDEPIM_NO_EXPORT
#elif defined(KDEPIM_NO_DEPRECATED_WARNINGS)
#  define KDEPIM_DEPRECATED
#  define KDEPIM_DEPRECATED_EXPORT KDEPIM_EXPORT
#  define KDEPIM_DEPRECATED_NO_EXPORT KDEPIM_NO_EXPORT
#else
#  define KDEPIM_DEPRECATED KDEPIM_DECL_DEPRECATED
#  define KDEPIM_DEPRECATED_EXPORT KDEPIM_DECL_DEPRECATED_EXPORT
#  define KDEPIM_DEPRECATED_NO_EXPORT KDEPIM_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KDEPIM_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KDEPIM_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KDEPIM_NO_DEPRECATED
#  define KDEPIM_DISABLE_DEPRECATED_BEFORE_AND_AT KDEPIM_VERSION
#endif
#ifdef KDEPIM_NO_DEPRECATED_WARNINGS
#  define KDEPIM_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KDEPIM_DEPRECATED_WARNINGS_SINCE
#  ifdef KDEPIM_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KDEPIM_DEPRECATED_WARNINGS_SINCE KDEPIM_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KDEPIM_DEPRECATED_WARNINGS_SINCE KDEPIM_VERSION
#  endif
#endif

#ifndef KDEPIM_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KDEPIM_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KDEPIM_DEPRECATED
#  define KDEPIM_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KDEPIM_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KDEPIM_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* KDEPIM_EXPORT_H */
