/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.Action;
import org.argouml.core.propertypanels.ui.UMLComboBox;
import org.argouml.core.propertypanels.ui.UMLComboBoxModel;
import org.argouml.i18n.Translator;
import org.argouml.model.Model;
import org.argouml.ui.UndoableAction;

class UMLLinkAssociationComboBoxModel
extends UMLComboBoxModel {
    private static final long serialVersionUID = 3232437122889409351L;

    public UMLLinkAssociationComboBoxModel(String propertyName, Object target) {
        super(target, propertyName, true);
    }

    protected boolean isValidElement(Object o) {
        return Model.getFacade().isAAssociation(o);
    }

    protected void buildModelList() {
        HashSet<Object> associations = new HashSet<Object>();
        Object t = this.getTarget();
        if (Model.getFacade().isALink(t)) {
            Collection linkEnds = Model.getFacade().getConnections(t);
            Iterator ile = linkEnds.iterator();
            while (ile.hasNext()) {
                Object instance = Model.getFacade().getInstance(ile.next());
                Collection c = Model.getFacade().getClassifiers(instance);
                for (Object classifier : c) {
                    Collection ae = Model.getFacade().getAssociationEnds(classifier);
                    for (Object associationEnd : ae) {
                        Object association = Model.getFacade().getAssociation(associationEnd);
                        associations.add(association);
                    }
                }
            }
        }
        this.setElements(associations);
    }

    protected Object getSelectedModelElement() {
        if (Model.getFacade().isALink(this.getTarget())) {
            return Model.getFacade().getAssociation(this.getTarget());
        }
        return null;
    }

    public Action getAction() {
        return new ActionSetLinkAssociation();
    }

    class ActionSetLinkAssociation
    extends UndoableAction {
        private static final long serialVersionUID = 6168167355078835252L;

        public ActionSetLinkAssociation() {
            super(Translator.localize((String)"Set"), null);
            this.putValue("ShortDescription", Translator.localize((String)"Set"));
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            Object source = e.getSource();
            Object oldAssoc = null;
            Object newAssoc = null;
            Object link = null;
            UMLComboBox box = (UMLComboBox)source;
            Object o = box.getTarget();
            if (Model.getFacade().isALink(o)) {
                link = o;
                oldAssoc = Model.getFacade().getAssociation(o);
            }
            Object n = box.getSelectedItem();
            if (Model.getFacade().isAAssociation(n)) {
                newAssoc = n;
            }
            if (newAssoc != oldAssoc && link != null && newAssoc != null) {
                Model.getCoreHelper().setAssociation(link, newAssoc);
            }
        }
    }
}

