/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.properties.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.tigris.gef.properties.PropCategoryManager;
import org.tigris.gef.properties.ui.ColorEditor;
import org.tigris.gef.properties.ui.PropSheet;
import org.tigris.gef.properties.ui.PropertyCanvas;
import org.tigris.gef.properties.ui.PropertySelector;
import org.tigris.gef.properties.ui.PropertyText;
import org.tigris.gef.properties.ui.PropsGridLayout;
import org.tigris.gef.properties.ui.RectangleEditor;

public class PropSheetCategory
extends PropSheet {
    public static final String dots = "";
    protected Hashtable _keysComps;
    protected Hashtable _compsKeys;
    protected Hashtable _inUse;
    protected Hashtable _labels;
    protected Hashtable _shown;
    protected String _category = "Misc";
    protected PropertyDescriptor[] _properties;
    protected JFrame _jframe;
    protected boolean inRecursion = false;

    public PropSheetCategory(JFrame f) {
        this._jframe = f;
        this.setTabName("no key");
        this.setLayout(new PropsGridLayout(4, 4));
        this.setSize(this.getInsets().left + this.getInsets().right + 250, this.getInsets().top + this.getInsets().bottom + 300);
        this.setFont(this.getPropertiesFont());
        this._keysComps = new Hashtable(20);
        this._compsKeys = new Hashtable(20);
        this._labels = new Hashtable(20);
        this._inUse = new Hashtable(20);
        this._shown = new Hashtable(20);
    }

    public String getCategory() {
        return this._category;
    }

    public void setCategory(String cat) {
        if (this._category.equals(cat)) {
            return;
        }
        this._category = cat;
        this.setTabName(cat);
        if (this._sel != null) {
            this.updateComponents();
            this.repaint();
        }
    }

    public Component addKeyComp(PropertyDescriptor pd) {
        Component comp = (Component)this._keysComps.get(pd);
        if (comp == null) {
            comp = this.makeComp(pd);
            this._keysComps.put(pd, comp);
            this._compsKeys.put(comp, pd);
            JLabel lab = new JLabel(pd.getName() + dots);
            this._labels.put(pd, lab);
        }
        this._inUse.put(pd, pd);
        return comp;
    }

    public void updateKeysComps() {
        this._inUse.clear();
        if (this._sel == null) {
            return;
        }
        Class<?> selClass = this._sel.getClass();
        try {
            BeanInfo bi = Introspector.getBeanInfo(selClass);
            this._properties = bi.getPropertyDescriptors();
        }
        catch (IntrospectionException ex) {
            System.out.println("PropertySheet: Couldn't introspect\n" + ex.toString());
            return;
        }
        for (int i = 0; i < this._properties.length; ++i) {
            boolean canPut;
            if (!PropCategoryManager.inCategory(this._category, this._properties[i])) continue;
            Component comp = this.addKeyComp(this._properties[i]);
            boolean bl = canPut = this._properties[i].getWriteMethod() != null;
            if (comp instanceof TextComponent) {
                ((TextComponent)comp).setEditable(canPut);
                continue;
            }
            comp.setEnabled(canPut);
        }
    }

    public void show(PropertyDescriptor pd) {
        JLabel lab = (JLabel)this._labels.get(pd);
        Component comp = (Component)this._keysComps.get(pd);
        this.setComponentValue(pd, comp);
        if (this._shown.containsKey(pd)) {
            return;
        }
        this.add(lab);
        this.add(comp);
        lab.setVisible(true);
        comp.setVisible(true);
        this._shown.put(pd, pd);
    }

    public void hide(PropertyDescriptor pd) {
        if (!this._shown.containsKey(pd)) {
            return;
        }
        JLabel lab = (JLabel)this._labels.get(pd);
        Component comp = (Component)this._keysComps.get(pd);
        lab.setVisible(false);
        comp.setVisible(false);
        this.remove(lab);
        this.remove(comp);
        this._shown.remove(pd);
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, 400);
    }

    public Dimension getSize() {
        return new Dimension(300, 400);
    }

    public Component makeComp(PropertyDescriptor pd) {
        Component comp = null;
        try {
            Method getter = pd.getReadMethod();
            Method setter = pd.getWriteMethod();
            Object[] args = new Object[]{};
            Object value = getter.invoke(this._sel, args);
            Class<?> type = pd.getPropertyType();
            PropertyEditor editor = null;
            Class<?> pec = pd.getPropertyEditorClass();
            if (pec != null) {
                try {
                    editor = (PropertyEditor)pec.newInstance();
                }
                catch (Exception ex) {
                    System.out.println("exception in makecomp");
                }
            }
            if (editor == null) {
                editor = PropertyEditorManager.findEditor(type);
            }
            if (editor == null) {
                return new JLabel(value == null ? "(null)" : value.toString());
            }
            editor.setValue(value);
            editor.addPropertyChangeListener(this);
            this._editorsPds.put(editor, pd);
            this._pdsEditors.put(pd, editor);
            if (editor.isPaintable() && editor.supportsCustomEditor()) {
                comp = new PropertyCanvas(this._jframe, editor);
            } else if (editor instanceof Component) {
                comp = (Component)((Object)editor);
            } else if (editor.getTags() != null) {
                comp = new PropertySelector(editor);
            } else if (editor.getAsText() != null) {
                String init = editor.getAsText();
                comp = new PropertyText(editor);
            } else {
                System.err.println("Warning: Property \"" + ((Object)pd).toString() + "\" has non-displayabale editor. Skipping.");
            }
        }
        catch (InvocationTargetException ex) {
            System.err.println("Skipping property " + ((Object)pd).toString() + " ; exception on target: " + ex.getTargetException());
            ex.getTargetException().printStackTrace();
        }
        catch (IllegalAccessException ex) {
            System.err.println("Skipping property " + ((Object)pd).toString() + " ; Illegal Access on target: " + ex.toString());
            ex.printStackTrace();
        }
        return comp;
    }

    public void setComponentValue(PropertyDescriptor pd, Component comp) {
        if (this.inRecursion) {
            return;
        }
        Object value = null;
        try {
            Method getter = pd.getReadMethod();
            Method setter = pd.getWriteMethod();
            Object[] args = new Object[]{};
            value = getter.invoke(this._sel, args);
        }
        catch (Exception ex) {
            System.out.println("unexpected Exception!");
        }
        if (value == null) {
            System.out.println("null value");
            return;
        }
        if (comp == null) {
            System.out.println("tag is null");
        }
        this.inRecursion = true;
        if (comp instanceof PropertyEditor) {
            ((PropertyEditor)((Object)comp)).setValue(value);
        } else if (comp instanceof PropertyText) {
            ((PropertyText)comp).setText(value.toString());
        } else if (comp instanceof PropertySelector) {
            String tag = value.toString();
            if (value instanceof Boolean) {
                tag = (Boolean)value != false ? "True" : "False";
            }
            if (tag == null) {
                System.out.println("tag is null");
            }
            ((PropertySelector)comp).setSelectedItem(tag);
        } else if (comp instanceof Label) {
            ((Label)comp).setText(value.toString());
        } else {
            PropertyEditor editor = (PropertyEditor)this._pdsEditors.get(pd);
            if (editor != null) {
                this._ignorePropChanges = true;
                editor.setValue(value);
                this._ignorePropChanges = false;
            }
        }
        this.inRecursion = false;
    }

    public void addNotify() {
        if (this._keysComps != null) {
            super.addNotify();
        }
    }

    public boolean canEdit(Object item) {
        return item != null && super.canEdit(item);
    }

    public void updateComponents() {
        super.updateComponents();
        this.updateKeysComps();
        Enumeration keysEnum = this._keysComps.keys();
        while (keysEnum.hasMoreElements()) {
            PropertyDescriptor pd = (PropertyDescriptor)keysEnum.nextElement();
            if (this._inUse.containsKey(pd)) {
                this.show(pd);
                continue;
            }
            this.hide(pd);
        }
        this.validate();
    }

    public void updateComponent(PropertyDescriptor pd) {
        Component comp = (Component)this._keysComps.get(pd);
        if (comp != null) {
            this.setComponentValue(pd, comp);
        }
    }

    static {
        String[] searchPath = new String[]{"org.tigris.gef.properties.ui", "sun.beans.editors"};
        PropertyEditorManager.setEditorSearchPath(searchPath);
        PropertyEditorManager.registerEditor(Color.class, ColorEditor.class);
        PropertyEditorManager.registerEditor(Rectangle.class, RectangleEditor.class);
    }
}

