/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.toolbar.toolbutton;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.tigris.toolbar.ToolBarManager;
import org.tigris.toolbar.toolbutton.AbstractButtonAction;
import org.tigris.toolbar.toolbutton.DropDownIcon;
import org.tigris.toolbar.toolbutton.ModalButton;
import org.tigris.toolbar.toolbutton.PopupToolBox;
import org.tigris.toolbar.toolbutton.ToolButton;

public class PopupToolBoxButton
extends ToolButton {
    private static final long serialVersionUID = -684520584458885655L;
    private PopupToolBox _popupToolBox;
    private Icon _standardIcon;
    private String tooltip;
    private boolean showSplitter;
    private String dropDownToolTip;
    private boolean popupButtonActive = true;
    private boolean popupMenuIsShowing = false;

    public PopupToolBoxButton(Action action, int n, int n2, boolean bl) {
        super(action);
        this.setAction(action);
        this._popupToolBox = new PopupToolBox(n, n2, bl);
        MyMouseListener myMouseListener = new MyMouseListener();
        this.addMouseMotionListener(myMouseListener);
        this.addMouseListener(myMouseListener);
    }

    public void setAction(Action action) {
        this._button = new JButton(action);
        Icon icon = this._button.getIcon();
        if (action instanceof AbstractButtonAction) {
            icon = ((AbstractButtonAction)action).getIcon();
        }
        this.tooltip = this._button.getToolTipText();
        if (this.tooltip == null || this.tooltip.trim().length() == 0) {
            this.tooltip = this._button.getText();
        }
        this._button.setText(null);
        if (icon != null) {
            this._standardIcon = new DropDownIcon((ImageIcon)icon);
        }
        super.setAction(new ToolButton.ToolButtonAction(this));
        this.setIcon(this._standardIcon);
        this.setText(null);
        this.setToolTipText(this.tooltip);
    }

    private void popup() {
        final JPopupMenu jPopupMenu = new JPopupMenu();
        MyPopupMenuListener myPopupMenuListener = new MyPopupMenuListener();
        jPopupMenu.addPopupMenuListener(myPopupMenuListener);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Component component = mouseEvent.getComponent();
                if (component instanceof ModalButton) {
                    Action action = ((ModalButton)component).getRealAction();
                    PopupToolBoxButton.this.setAction(action);
                    action.putValue("popped", true);
                    PopupToolBoxButton.this.setSelected(true);
                    ButtonModel buttonModel = PopupToolBoxButton.this.getModel();
                    buttonModel.setRollover(true);
                    if (!ToolBarManager.alwaysUseStandardRollover()) {
                        PopupToolBoxButton.this.setBorderPainted(true);
                    }
                    buttonModel.setArmed(true);
                }
                jPopupMenu.setVisible(false);
            }
        };
        this._popupToolBox.setButtonMouseListener(mouseAdapter);
        this._popupToolBox.rebuild();
        jPopupMenu.add(this._popupToolBox);
        jPopupMenu.show(this, 0, this.getHeight());
        this.popupMenuIsShowing = true;
    }

    public JButton add(Action action) {
        if (action.getValue("isDefault") instanceof Boolean && ((Boolean)action.getValue("isDefault")).booleanValue()) {
            this.setAction(action);
        }
        return this._popupToolBox.add(action);
    }

    private int getSplitterPosn() {
        return this.getIconPosn() + this._button.getIcon().getIconWidth() + 3;
    }

    private int getIconPosn() {
        int n = (this.getWidth() - this._standardIcon.getIconWidth()) / 2;
        return n;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Color[] colorArray = new Color[]{this.getBackground(), UIManager.getColor("controlDkShadow"), UIManager.getColor("controlText"), UIManager.getColor("controlHighlight")};
        if (this.showSplitter) {
            this.showSplitter(colorArray[1], graphics, this.getSplitterPosn(), 1, this.getHeight() - 4);
            this.showSplitter(colorArray[3], graphics, this.getSplitterPosn() + 1, 1, this.getHeight() - 4);
        }
    }

    public void setDropDownToolTip(String string) {
        this.dropDownToolTip = string;
    }

    public void showSplitter(Color color, Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(color);
        graphics.drawLine(n, n2 + 0, n, n2 + n3);
    }

    public void showSplitter(boolean bl) {
        if (bl && !this.showSplitter) {
            this.showSplitter = true;
            this.repaint();
            String string = null;
            Container container = this.getParent();
            if (container instanceof JComponent) {
                string = this.dropDownToolTip;
            }
            if (string == null) {
                string = "Select Tool";
            }
            this.setToolTipText(string);
        } else if (!bl && this.showSplitter) {
            this.showSplitter = false;
            this.repaint();
            this.setToolTipText(this.tooltip);
        }
    }

    protected void performAction(ActionEvent actionEvent) {
        if (this.showSplitter) {
            if (this.popupButtonActive) {
                this.popup();
                this.popupButtonActive = false;
            } else {
                this.popupButtonActive = true;
            }
        } else {
            super.performAction(actionEvent);
        }
    }

    private class MyMouseListener
    extends MouseInputAdapter {
        private MyMouseListener() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (PopupToolBoxButton.this._standardIcon != null) {
                PopupToolBoxButton.this.showSplitter(mouseEvent.getX() >= PopupToolBoxButton.this.getSplitterPosn());
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (PopupToolBoxButton.this._standardIcon != null) {
                PopupToolBoxButton.this.showSplitter(mouseEvent.getX() >= PopupToolBoxButton.this.getSplitterPosn());
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (PopupToolBoxButton.this._standardIcon != null) {
                PopupToolBoxButton.this.showSplitter(false);
            }
            if (!PopupToolBoxButton.this.popupButtonActive && !PopupToolBoxButton.this.popupMenuIsShowing) {
                PopupToolBoxButton.this.popupButtonActive = true;
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (PopupToolBoxButton.this.popupButtonActive && PopupToolBoxButton.this.showSplitter) {
                PopupToolBoxButton.this.popup();
            }
        }
    }

    private class MyPopupMenuListener
    extends AbstractAction
    implements PopupMenuListener {
        private static final long serialVersionUID = 5826768442190256559L;

        private MyPopupMenuListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            if (PopupToolBoxButton.this.showSplitter) {
                PopupToolBoxButton.this.popupButtonActive = false;
            } else {
                PopupToolBoxButton.this.popupButtonActive = true;
            }
            PopupToolBoxButton.this.popupMenuIsShowing = false;
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }
    }
}

