/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.xsd;

import com.thaiopensource.relaxng.edit.AbstractVisitor;
import com.thaiopensource.relaxng.edit.AttributePattern;
import com.thaiopensource.relaxng.edit.ChoiceNameClass;
import com.thaiopensource.relaxng.edit.CompositePattern;
import com.thaiopensource.relaxng.edit.DefineComponent;
import com.thaiopensource.relaxng.edit.DivComponent;
import com.thaiopensource.relaxng.edit.ElementPattern;
import com.thaiopensource.relaxng.edit.IncludeComponent;
import com.thaiopensource.relaxng.edit.NameNameClass;
import com.thaiopensource.relaxng.edit.NamespaceContext;
import com.thaiopensource.relaxng.edit.UnaryPattern;
import com.thaiopensource.relaxng.edit.ValuePattern;
import com.thaiopensource.relaxng.output.xsd.SchemaInfo;
import com.thaiopensource.relaxng.output.xsd.SourceUriGenerator;
import com.thaiopensource.util.VoidValue;
import com.thaiopensource.xml.util.Naming;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PrefixManager
implements SourceUriGenerator {
    private final Map<String, String> prefixMap = new HashMap<String, String>();
    private final Set<String> usedPrefixes = new HashSet<String>();
    private final Set<String> reservedPrefixes = new HashSet<String>();
    private int nextGenIndex = 1;
    private static final String[] xsdPrefixes = new String[]{"xs", "xsd"};
    private static final int MAX_PREFIX_LENGTH = 10;

    PrefixManager(SchemaInfo schemaInfo) {
        this.usePrefix("xml", "http://www.w3.org/XML/1998/namespace");
        new PrefixSelector(schemaInfo).assignPrefixes();
    }

    String getPrefix(String string) {
        String string2 = this.prefixMap.get(string);
        if (string2 == null && string.equals("http://www.w3.org/2001/XMLSchema")) {
            for (int i = 0; i < xsdPrefixes.length; ++i) {
                if (!this.tryUsePrefix(xsdPrefixes[i], string)) continue;
                return xsdPrefixes[i];
            }
        }
        if (string2 == null) {
            string2 = this.tryUseUri(string);
        }
        if (string2 == null) {
            while (!this.tryUsePrefix(string2 = "ns" + Integer.toString(this.nextGenIndex++), string)) {
            }
        }
        return string2;
    }

    private String tryUseUri(String string) {
        String string2 = PrefixManager.chooseSegment(string);
        if (string2 == null) {
            return null;
        }
        if (string2.length() <= 10 && this.tryUsePrefix(string2, string)) {
            return string2;
        }
        for (int i = 1; i <= string2.length(); ++i) {
            String string3 = string2.substring(0, i);
            if (!this.tryUsePrefix(string3, string)) continue;
            return string3;
        }
        return null;
    }

    private boolean tryUsePrefix(String string, String string2) {
        if (!this.prefixOk(string, string2)) {
            return false;
        }
        this.usePrefix(string, string2);
        return true;
    }

    private boolean prefixOk(String string, String string2) {
        return !this.usedPrefixes.contains(string) && (!this.reservedPrefixes.contains(string) || !string2.equals("http://www.w3.org/2001/XMLSchema"));
    }

    private void usePrefix(String string, String string2) {
        this.usedPrefixes.add(string);
        this.prefixMap.put(string2, string);
    }

    private static String chooseSegment(String string) {
        String string2;
        int n;
        int n2 = string.indexOf(35);
        if (n2 >= 0) {
            String string3 = string.substring(n2 + 1).toLowerCase();
            if (Naming.isNcname(string3)) {
                return string3;
            }
        } else {
            n2 = string.length();
        }
        while ((n = string.lastIndexOf(47, n2 - 1)) >= 0 && (n <= 0 || string.charAt(n - 1) != '/')) {
            String string4 = string.substring(n + 1, n2).toLowerCase();
            if (PrefixManager.segmentOk(string4)) {
                return string4;
            }
            n2 = n;
        }
        n2 = string.indexOf(58);
        if (n2 >= 0 && PrefixManager.segmentOk(string2 = string.substring(n2 + 1).toLowerCase())) {
            return string2;
        }
        return null;
    }

    private static boolean segmentOk(String string) {
        return Naming.isNcname(string) && !string.equals("ns") && !string.equals("namespace");
    }

    public String generateSourceUri(String string) {
        if (string.equals("")) {
            return "local";
        }
        return "/" + this.getPrefix(string);
    }

    class PrefixSelector
    extends AbstractVisitor {
        private final SchemaInfo si;
        private String inheritedNamespace;
        private final Map<String, Map<String, PrefixUsage>> namespacePrefixUsageMap = new HashMap<String, Map<String, PrefixUsage>>();

        PrefixSelector(SchemaInfo schemaInfo) {
            this.si = schemaInfo;
            this.inheritedNamespace = "";
            schemaInfo.getGrammar().componentsAccept(this);
            NamespaceContext namespaceContext = schemaInfo.getGrammar().getContext();
            if (namespaceContext != null) {
                for (String string : namespaceContext.getPrefixes()) {
                    if (string.equals("")) continue;
                    this.notePrefix(string, this.resolveNamespace(namespaceContext.getNamespace(string)));
                }
            }
        }

        public VoidValue visitElement(ElementPattern elementPattern) {
            elementPattern.getNameClass().accept(this);
            elementPattern.getChild().accept(this);
            return VoidValue.VOID;
        }

        public VoidValue visitAttribute(AttributePattern attributePattern) {
            return attributePattern.getNameClass().accept(this);
        }

        public VoidValue visitChoice(ChoiceNameClass choiceNameClass) {
            choiceNameClass.childrenAccept(this);
            return VoidValue.VOID;
        }

        public VoidValue visitName(NameNameClass nameNameClass) {
            this.notePrefix(nameNameClass.getPrefix(), this.resolveNamespace(nameNameClass.getNamespaceUri()));
            return VoidValue.VOID;
        }

        public VoidValue visitValue(ValuePattern valuePattern) {
            for (Map.Entry<String, String> entry : valuePattern.getPrefixMap().entrySet()) {
                String string = entry.getKey();
                if (string == null || string.equals("")) continue;
                String string2 = this.resolveNamespace(entry.getValue());
                this.notePrefix(string, string2);
                if (string2.equals("http://www.w3.org/2001/XMLSchema")) continue;
                PrefixManager.this.reservedPrefixes.add(string);
            }
            return VoidValue.VOID;
        }

        private String resolveNamespace(String string) {
            return string == NameNameClass.INHERIT_NS ? this.inheritedNamespace : string;
        }

        private void notePrefix(String string, String string2) {
            PrefixUsage prefixUsage;
            if (string == null || string2 == null || string2.equals("")) {
                return;
            }
            Map<String, PrefixUsage> map = this.namespacePrefixUsageMap.get(string2);
            if (map == null) {
                map = new HashMap<String, PrefixUsage>();
                this.namespacePrefixUsageMap.put(string2, map);
            }
            if ((prefixUsage = map.get(string)) == null) {
                prefixUsage = new PrefixUsage();
                map.put(string, prefixUsage);
            }
            ++prefixUsage.count;
        }

        public VoidValue visitComposite(CompositePattern compositePattern) {
            compositePattern.childrenAccept(this);
            return VoidValue.VOID;
        }

        public VoidValue visitUnary(UnaryPattern unaryPattern) {
            return unaryPattern.getChild().accept(this);
        }

        public VoidValue visitDefine(DefineComponent defineComponent) {
            defineComponent.getBody().accept(this);
            return VoidValue.VOID;
        }

        public VoidValue visitDiv(DivComponent divComponent) {
            divComponent.componentsAccept(this);
            return VoidValue.VOID;
        }

        public VoidValue visitInclude(IncludeComponent includeComponent) {
            String string = this.inheritedNamespace;
            this.inheritedNamespace = includeComponent.getNs();
            this.si.getSchema(includeComponent.getUri()).componentsAccept(this);
            this.inheritedNamespace = string;
            return VoidValue.VOID;
        }

        void assignPrefixes() {
            for (Map.Entry<String, Map<String, PrefixUsage>> entry : this.namespacePrefixUsageMap.entrySet()) {
                Map<String, PrefixUsage> map;
                String string = entry.getKey();
                if (string.equals("") || string.equals("http://www.w3.org/XML/1998/namespace") || (map = entry.getValue()) == null) continue;
                Map.Entry<String, PrefixUsage> entry2 = null;
                for (Map.Entry<String, PrefixUsage> entry3 : map.entrySet()) {
                    if (entry2 != null && entry3.getValue().count <= ((PrefixUsage)entry2.getValue()).count || !PrefixManager.this.prefixOk(entry3.getKey(), string)) continue;
                    entry2 = entry3;
                }
                if (entry2 == null) continue;
                PrefixManager.this.usePrefix((String)entry2.getKey(), string);
            }
        }
    }

    static class PrefixUsage {
        int count;

        PrefixUsage() {
        }
    }
}

