/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.stream;

import org.apache.log4j.Logger;
import org.eso.util.stream.PassThroughTask;
import org.eso.util.stream.Task;

public class Module {
    static final Logger logger = Logger.getLogger(Module.class);
    private static final String classLogName = "Module";
    private boolean moduleOpen = false;
    private final Task downstreamTask;
    private final Task upstreamTask;

    public Module(Task downstreamTask, Task upstreamTask) {
        String methodLogName = "Module::Module()";
        logger.trace("Module::Module()");
        if (downstreamTask == null) {
            downstreamTask = new PassThroughTask();
        }
        if (upstreamTask == null) {
            upstreamTask = new PassThroughTask();
        }
        downstreamTask.setContainingModule(this);
        upstreamTask.setContainingModule(this);
        this.downstreamTask = downstreamTask;
        this.upstreamTask = upstreamTask;
    }

    public final synchronized void open() {
        String methodLogName = "Module::open()";
        logger.trace("Module::open()");
        logger.debug("Module::open() - opening module.");
        this.downstreamTask.open();
        this.upstreamTask.open();
        this.moduleOpen = true;
    }

    public final boolean isOpen() {
        String methodLogName = "Module::isOpen()";
        logger.trace("Module::isOpen()");
        return this.moduleOpen;
    }

    public final synchronized void close() {
        String methodLogName = "Module::close()";
        logger.trace("Module::close()");
        logger.debug("Module::close() - closing module.");
        this.downstreamTask.close();
        this.upstreamTask.close();
        this.moduleOpen = false;
    }

    public final synchronized void restart() {
        String methodLogName = "Module::restart()";
        logger.trace("Module::restart()");
        logger.debug("Module::restart() - restarting module.");
        this.close();
        this.open();
    }

    public final void connectDownstreamModule(Module module) {
        String methodLogName = "Module::connectDownstreamModule()";
        logger.trace("Module::connectDownstreamModule()");
        if (this.moduleOpen) {
            String logMessage = "Module::connectDownstreamModule() - module must not be open when calling this method.";
            logger.fatal("Module::connectDownstreamModule() - module must not be open when calling this method.");
            throw new AssertionError((Object)"Module::connectDownstreamModule() - module must not be open when calling this method.");
        }
        logger.debug("Module::connectDownstreamModule() - connecting.");
        this.downstreamTask.setNextTask(module.downstreamTask);
    }

    public final void connectUpstreamModule(Module module) {
        String methodLogName = "Module::connectUpstreamModule()";
        logger.trace("Module::connectUpstreamModule()");
        if (this.moduleOpen) {
            String logMessage = "Module::connectUpstreamModule() - module must not be open when calling this method.";
            logger.fatal("Module::connectUpstreamModule() - module must not be open when calling this method.");
            throw new AssertionError((Object)"Module::connectUpstreamModule() - module must not be open when calling this method.");
        }
        logger.debug("Module::connectUpstreamModule() - connecting.");
        this.upstreamTask.setNextTask(module.upstreamTask);
    }

    public final Module disconnectDownstreamModule() {
        String methodLogName = "Module::disconnectDownstreamModule()";
        logger.trace("Module::disconnectDownstreamModule()");
        if (this.moduleOpen) {
            String logMessage = "Module::disconnectDownstreamModule() - module must not be open when calling this method.";
            logger.fatal("Module::disconnectDownstreamModule() - module must not be open when calling this method.");
            throw new AssertionError((Object)"Module::disconnectDownstreamModule() - module must not be open when calling this method.");
        }
        Module oldDownstreamModule = null;
        Task oldDownstreamNextTask = this.downstreamTask.getNextTask();
        if (oldDownstreamNextTask != null) {
            oldDownstreamModule = oldDownstreamNextTask.getContainingModule();
        }
        logger.debug("Module::disconnectDownstreamModule() - disconnecting.");
        this.downstreamTask.setNextTask(null);
        return oldDownstreamModule;
    }

    public final Module disconnectUpstreamModule() {
        String methodLogName = "Module::disconnectUpstreamModule()";
        logger.trace("Module::disconnectUpstreamModule()");
        if (this.moduleOpen) {
            String logMessage = "Module::disconnectUpstreamModule() - module must not be open when calling this method.";
            logger.fatal("Module::disconnectUpstreamModule() - module must not be open when calling this method.");
            throw new AssertionError((Object)"Module::disconnectUpstreamModule() - module must not be open when calling this method.");
        }
        Module oldUpstreamModule = null;
        Task oldUpstreamNextTask = this.upstreamTask.getNextTask();
        if (oldUpstreamNextTask != null) {
            oldUpstreamModule = oldUpstreamNextTask.getContainingModule();
        }
        logger.debug("Module::disconnectUpstreamModule() - disconnecting.");
        this.upstreamTask.setNextTask(null);
        return oldUpstreamModule;
    }

    public final Task getDownstreamTask() {
        String methodLogName = "Module::getDownstreamTask()";
        logger.trace("Module::getDownstreamTask()");
        return this.downstreamTask;
    }

    public final Task getUpstreamTask() {
        String methodLogName = "Module::getUpstreamTask()";
        logger.trace("Module::getUpstreamTask()");
        return this.upstreamTask;
    }

    public final Task getSiblingTask(Task task) {
        String methodLogName = "Module::getSiblingTask()";
        logger.trace("Module::getSiblingTask()");
        if (task == this.downstreamTask) {
            return this.upstreamTask;
        }
        if (task == this.upstreamTask) {
            return this.downstreamTask;
        }
        return null;
    }
}

