/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.datatransfer;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.eso.util.misc.SystemCommand;

public class FileCopyCommand
extends SystemCommand {
    static final Logger logger = Logger.getLogger(FileCopyCommand.class);
    private final String HOST_KEYWORD = "\\$HOST";
    private final String PORT_KEYWORD = "\\$PORT";
    private final String USER_KEYWORD = "\\$USER";
    private final String DIR_KEYWORD = "\\$DIR";
    private final String FILENAME_KEYWORD = "\\$FILENAME";
    private final String FILEID_KEYWORD = "\\$FILEID";
    private final String FILEVERSION_KEYWORD = "\\$FILEVERSION";
    private static final String thisClass = "FileCopyCommand";

    public FileCopyCommand(String copyCommand, String filename, URL destUrl, long timeout) {
        String thisMethod = "FileCopyCommand::FileCopyCommand()";
        if (copyCommand == null || filename == null || destUrl == null) {
            String message = thisMethod + " - Some arguments are missing";
            logger.error(message);
            throw new IllegalArgumentException(message);
        }
        logger.trace(thisMethod);
        String command = copyCommand;
        if (destUrl.getHost() != null) {
            command = command.replaceAll("\\$HOST", destUrl.getHost());
        }
        command = command.replace("\\$PORT", String.valueOf(destUrl.getPort()));
        if (destUrl.getPath() != null) {
            command = command.replaceAll("\\$DIR", destUrl.getPath());
        }
        command = command.replaceAll("\\$FILENAME", filename);
        this.setCommandLine(command);
        this.setTimeout(timeout);
    }

    public FileCopyCommand(String copyCommand, String filename, String fileid, String fileversion, URL destUrl, long timeout) {
        String thisMethod = "FileCopyCommand::FileCopyCommand()";
        logger.trace(thisMethod);
        if (copyCommand == null || filename == null || fileid == null || fileversion == null || destUrl == null) {
            String message = thisMethod + " - Some arguments are missing";
            logger.error(message);
            throw new IllegalArgumentException(message);
        }
        String command = copyCommand;
        if (destUrl.getHost() != null) {
            command = command.replaceAll("\\$HOST", destUrl.getHost());
        }
        command = command.replaceAll("\\$PORT", String.valueOf(destUrl.getPort()));
        if (destUrl.getPath() != null) {
            command = command.replaceAll("\\$DIR", destUrl.getPath());
        }
        command = command.replaceAll("\\$FILENAME", filename);
        command = command.replaceAll("\\$FILEID", fileid);
        command = command.replaceAll("\\$FILEVERSION", fileversion);
        this.setCommandLine(command);
        this.setTimeout(timeout);
    }

    public FileCopyCommand(String copyCommand, String filename, String fileid, String fileversion, String copyUser, URL destUrl, long timeout) {
        super(copyCommand);
        String thisMethod = "FileCopyCommand::FileCopyCommand()";
        logger.trace(thisMethod);
        if (copyCommand == null || filename == null || fileid == null || fileversion == null || copyUser == null || destUrl == null) {
            String message = thisMethod + " - Some arguments are missing";
            logger.error(message);
            throw new IllegalArgumentException(message);
        }
        String command = copyCommand;
        if (destUrl.getHost() != null) {
            command = command.replaceAll("\\$HOST", destUrl.getHost());
        }
        command = command.replaceAll("\\$PORT", String.valueOf(destUrl.getPort()));
        if (destUrl.getPath() != null) {
            command = command.replaceAll("\\$DIR", destUrl.getPath());
        }
        command = command.replaceAll("\\$FILENAME", filename);
        command = command.replaceAll("\\$FILEID", fileid);
        command = command.replaceAll("\\$FILEVERSION", fileversion);
        command = command.replaceAll("\\$USER", copyUser);
        this.setCommandLine(command);
        this.setTimeout(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        BasicConfigurator.configure();
        String FS = System.getProperty("file.separator");
        String copyCmd = "rcp $FILENAME $HOST:$DIR";
        String filename = "/tmp/toto.txt";
        URL destUrl = null;
        try {
            destUrl = new URL("http://dmdlinb/tmp");
        }
        catch (MalformedURLException e2) {
            e2.printStackTrace();
        }
        FileCopyCommand cmd = new FileCopyCommand(copyCmd, filename, destUrl, 1800L);
        logger.debug(cmd.getCommandLine());
        try {
            cmd.execute();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        catch (IllegalStateException e4) {
            e4.printStackTrace();
        }
        catch (InterruptedException e5) {
            e5.printStackTrace();
        }
        catch (TimeoutException e6) {
            e6.printStackTrace();
        }
        finally {
            logger.debug("Exit status = " + cmd.getExitStatus());
            if (cmd.getExitStatus() != 0) {
                if (cmd.getStandardErrorString() != null) {
                    logger.error(cmd.getStandardErrorString());
                }
            } else if (cmd.getStandardOutputString() != null) {
                logger.info(cmd.getStandardOutputString());
            }
        }
    }
}

