/*
 * Decompiled with CFR 0.152.
 */
package org.eso.oca.fits;

import java.math.BigDecimal;
import java.math.BigInteger;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import org.apache.log4j.Logger;
import org.eso.oca.fits.TypeDeterminationException;
import org.eso.oca.fits.UndefinedFITSValue;
import org.eso.oca.fits.UntypedFITSValue;

public class TypedHeaderCard
extends HeaderCard {
    static Logger logger = Logger.getLogger(TypedHeaderCard.class);
    public static final int UNKNOWN = 0;
    public static final int UNDEFINED = 1;
    public static final int UNTYPED = 2;
    public static final int STRING = 3;
    public static final int BOOLEAN = 4;
    public static final int INTEGER = 5;
    public static final int FLOAT = 6;
    public static final String KEY_PREFIX_DOTTED = new String("HIERARCH.ESO.");
    public static final String KEY_PREFIX_SPACED = new String("HIERARCH ESO ");
    public static final int SHORT_DOTTED = 0;
    public static final int SHORT_SPACED = 1;
    public static final int LONG_DOTTED = 2;
    public static final int LONG_SPACED = 3;
    private int valueType;
    private Object valueObject;

    public TypedHeaderCard(HeaderCard card) throws HeaderCardException, TypeDeterminationException {
        super(card.toString());
        this.establishType();
    }

    public TypedHeaderCard(String cardImage) throws HeaderCardException, TypeDeterminationException {
        super(cardImage);
        this.establishType();
    }

    public TypedHeaderCard(String key, boolean isDefined) throws HeaderCardException, TypeDeterminationException {
        super(key, null, null);
        if (isDefined) {
            this.valueType = 2;
            this.valueObject = new UntypedFITSValue();
        } else {
            this.valueType = 1;
            this.valueObject = new UndefinedFITSValue();
        }
    }

    public TypedHeaderCard(String key, boolean value, String comment) throws HeaderCardException, TypeDeterminationException {
        super(key, value, comment);
        this.establishType();
    }

    public TypedHeaderCard(String key, double value, String comment) throws HeaderCardException, TypeDeterminationException {
        super(key, value, comment);
        this.establishType();
    }

    public TypedHeaderCard(String key, int value, String comment) throws HeaderCardException, TypeDeterminationException {
        super(key, value, comment);
        this.establishType();
    }

    public TypedHeaderCard(String key, long value, String comment) throws HeaderCardException, TypeDeterminationException {
        super(key, value, comment);
        this.establishType();
    }

    public TypedHeaderCard(String key, String value, String comment) throws HeaderCardException, TypeDeterminationException {
        super(key, value, comment);
        this.establishType();
    }

    public TypedHeaderCard(String key, String value, String comment, boolean nullable) throws HeaderCardException, TypeDeterminationException {
        super(key, value, comment, nullable);
        this.establishType();
    }

    public static String formatKey(String key, int format) {
        String prefix = KEY_PREFIX_DOTTED;
        String result = key;
        switch (format) {
            case 0: 
            case 2: {
                result = key.replace(' ', '.');
                break;
            }
            case 1: 
            case 3: {
                result = key.replace('.', ' ');
                prefix = KEY_PREFIX_SPACED;
            }
        }
        switch (format) {
            case 0: 
            case 1: {
                if (result.indexOf(prefix) != 0) break;
                result = result.substring(prefix.length());
                break;
            }
            case 2: {
                if (result.indexOf(46) <= 0 || result.indexOf(prefix) >= 0) break;
                result = prefix + result;
                break;
            }
            case 3: {
                if (result.indexOf(32) <= 0 || result.indexOf(prefix) >= 0) break;
                result = prefix + result;
            }
        }
        return result;
    }

    public String getKey(int format) {
        return TypedHeaderCard.formatKey(this.getKey(), format);
    }

    private boolean tryAsFITSInteger() {
        try {
            String value = this.getValue();
            if (value.length() > 0 && value.charAt(0) == '+') {
                value = value.substring(1);
            }
            this.valueObject = new BigInteger(value);
            this.valueType = 5;
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean tryAsFITSFloat() {
        try {
            String value = this.getValue();
            if (value.matches("[^\\d\\.]\\z")) {
                throw new NumberFormatException();
            }
            this.valueObject = new BigDecimal(value.replace('D', 'E'));
            this.valueType = 6;
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private void establishType() throws TypeDeterminationException {
        String value = this.getValue();
        if (value == null) {
            this.valueType = 2;
            this.valueObject = new UntypedFITSValue();
            return;
        }
        if (value.equalsIgnoreCase("nan")) {
            this.valueType = 2;
            this.valueObject = new UntypedFITSValue();
            return;
        }
        if (this.isStringValue()) {
            this.valueType = 3;
            this.valueObject = value.trim();
            return;
        }
        if (value.equals("T")) {
            this.valueType = 4;
            this.valueObject = new Boolean(true);
            return;
        }
        if (value.equals("F")) {
            this.valueType = 4;
            this.valueObject = new Boolean(false);
            return;
        }
        if (this.tryAsFITSInteger()) {
            return;
        }
        if (this.tryAsFITSFloat()) {
            return;
        }
        String message = "No value type could be deduced for '" + this.getKey() + " = " + this.getValue() + " / " + this.getComment() + "'.";
        logger.error(message);
        throw new TypeDeterminationException(message);
    }

    public int getType() {
        return this.valueType;
    }

    public String getTypeString() {
        String result;
        switch (this.valueType) {
            case 1: {
                result = "UNDEFINED";
                break;
            }
            case 2: {
                result = "UNTYPED";
                break;
            }
            case 3: {
                result = "STRING";
                break;
            }
            case 4: {
                result = "BOOLEAN";
                break;
            }
            case 5: {
                result = "INTEGER";
                break;
            }
            case 6: {
                result = "FLOAT";
                break;
            }
            default: {
                result = "UNKNOWN(" + this.valueType + ")";
            }
        }
        return result;
    }

    public static int findFITSType(Object candidate) {
        Class<?> type = candidate.getClass();
        int result = type.equals(UndefinedFITSValue.class) ? 1 : (type.equals(UntypedFITSValue.class) ? 2 : (type.equals(String.class) ? 3 : (type.equals(Boolean.class) ? 4 : (type.equals(BigInteger.class) ? 5 : (type.equals(BigDecimal.class) ? 6 : 0)))));
        return result;
    }

    public static String findFITSTypeString(Object candidate) {
        Class<?> type = candidate.getClass();
        String result = type.equals(UndefinedFITSValue.class) ? "UNDEFINED" : (type.equals(UntypedFITSValue.class) ? "UNTYPED" : (type.equals(String.class) ? "STRING" : (type.equals(Boolean.class) ? "BOOLEAN" : (type.equals(BigInteger.class) ? "INTEGER" : (type.equals(BigDecimal.class) ? "FLOAT" : "UNKNOWN(" + type.getName() + ")")))));
        return result;
    }

    public Object getValueObject() {
        return this.valueObject;
    }

    public boolean isUndefined() {
        return this.valueType == 1;
    }

    public boolean isDefined() {
        return this.valueType != 1;
    }

    public boolean isUntyped() {
        return this.valueType == 2;
    }

    public boolean isString() {
        return this.valueType == 3;
    }

    public boolean isBoolean() {
        return this.valueType == 4;
    }

    public boolean isInteger() {
        return this.valueType == 5;
    }

    public boolean isFloat() {
        return this.valueType == 6;
    }
}

