/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;

public abstract class TaskDialog
extends JDialog {
    private Timer progressTimer = null;
    private JProgressBar progressBar = null;
    private JLabel progressText = null;

    public TaskDialog(Frame parent, String title, boolean modal) {
        super(parent, title, modal);
    }

    public void initTask() {
        this.progressBar = new JProgressBar(0, this.getLengthOfTask());
        this.progressBar.setValue(0);
        this.progressText = new JLabel(new ImageIcon(TaskDialog.class.getResource("/org/eso/gasgano/gui/icons/readfits.gif")));
        this.progressText.setText(this.getProgressMessage());
        this.progressText.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.progressBar.setStringPainted(true);
        this.getContentPane().add((Component)this.progressBar, "South");
        this.getContentPane().add((Component)this.progressText, "North");
        this.progressTimer = new Timer(1000, new TimerListener());
        this.go();
        this.progressTimer.start();
    }

    public abstract void go();

    public abstract int getLengthOfTask();

    public abstract int getCurrent();

    public abstract String getProgressMessage();

    public abstract boolean done();

    public void cleanup() {
        this.progressTimer.stop();
        this.setVisible(false);
        this.dispose();
    }

    class TimerListener
    implements ActionListener {
        TimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TaskDialog.this.done()) {
                TaskDialog.this.cleanup();
            } else {
                TaskDialog.this.progressBar.setValue(TaskDialog.this.getCurrent());
                TaskDialog.this.progressText.setText(TaskDialog.this.getProgressMessage());
            }
        }
    }
}

